package zio.aws.mediatailor.model
import scala.jdk.CollectionConverters.*
sealed trait ChannelState {
  def unwrap: software.amazon.awssdk.services.mediatailor.model.ChannelState
}
object ChannelState {
  def wrap(
      value: software.amazon.awssdk.services.mediatailor.model.ChannelState
  ): zio.aws.mediatailor.model.ChannelState = value match {
    case software.amazon.awssdk.services.mediatailor.model.ChannelState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediatailor.model.ChannelState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.mediatailor.model.ChannelState.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediatailor.model.ChannelState {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.ChannelState =
      software.amazon.awssdk.services.mediatailor.model.ChannelState.UNKNOWN_TO_SDK_VERSION
  }
  case object RUNNING extends zio.aws.mediatailor.model.ChannelState {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.ChannelState =
      software.amazon.awssdk.services.mediatailor.model.ChannelState.RUNNING
  }
  case object STOPPED extends zio.aws.mediatailor.model.ChannelState {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.ChannelState =
      software.amazon.awssdk.services.mediatailor.model.ChannelState.STOPPED
  }
}
