package zio.aws.mediatailor.model
import scala.jdk.CollectionConverters.*
sealed trait Tier {
  def unwrap: software.amazon.awssdk.services.mediatailor.model.Tier
}
object Tier {
  def wrap(
      value: software.amazon.awssdk.services.mediatailor.model.Tier
  ): zio.aws.mediatailor.model.Tier = value match {
    case software.amazon.awssdk.services.mediatailor.model.Tier.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediatailor.model.Tier.BASIC =>
      val r = BASIC
      r
    case software.amazon.awssdk.services.mediatailor.model.Tier.STANDARD =>
      val r = STANDARD
      r
  }
  case object unknownToSdkVersion extends zio.aws.mediatailor.model.Tier {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.Tier =
      software.amazon.awssdk.services.mediatailor.model.Tier.UNKNOWN_TO_SDK_VERSION
  }
  case object BASIC extends zio.aws.mediatailor.model.Tier {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.Tier =
      software.amazon.awssdk.services.mediatailor.model.Tier.BASIC
  }
  case object STANDARD extends zio.aws.mediatailor.model.Tier {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.Tier =
      software.amazon.awssdk.services.mediatailor.model.Tier.STANDARD
  }
}
