package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.{__timestampUnix, __string}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Alert(
    alertCode: __string,
    alertMessage: __string,
    lastModifiedTime: __timestampUnix,
    relatedResourceArns: Iterable[__string],
    resourceArn: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.Alert = {
    import Alert.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.Alert
      .builder()
      .alertCode(alertCode: java.lang.String)
      .alertMessage(alertMessage: java.lang.String)
      .lastModifiedTime(lastModifiedTime: Instant)
      .relatedResourceArns(relatedResourceArns.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .resourceArn(resourceArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.Alert.ReadOnly =
    zio.aws.mediatailor.model.Alert.wrap(buildAwsValue())
}
object Alert {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.mediatailor.model.Alert] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.Alert =
      zio.aws.mediatailor.model.Alert(
        alertCode,
        alertMessage,
        lastModifiedTime,
        relatedResourceArns,
        resourceArn
      )
    def alertCode: __string
    def alertMessage: __string
    def lastModifiedTime: __timestampUnix
    def relatedResourceArns: List[__string]
    def resourceArn: __string
    def getAlertCode: ZIO[Any, Nothing, __string] = ZIO.succeed(alertCode)
    def getAlertMessage: ZIO[Any, Nothing, __string] = ZIO.succeed(alertMessage)
    def getLastModifiedTime: ZIO[Any, Nothing, __timestampUnix] =
      ZIO.succeed(lastModifiedTime)
    def getRelatedResourceArns: ZIO[Any, Nothing, List[__string]] =
      ZIO.succeed(relatedResourceArns)
    def getResourceArn: ZIO[Any, Nothing, __string] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.Alert
  ) extends zio.aws.mediatailor.model.Alert.ReadOnly {
    override val alertCode: __string = impl.alertCode(): __string
    override val alertMessage: __string = impl.alertMessage(): __string
    override val lastModifiedTime: __timestampUnix =
      impl.lastModifiedTime(): __timestampUnix
    override val relatedResourceArns: List[__string] = impl
      .relatedResourceArns()
      .asScala
      .map { item =>
        item: __string
      }
      .toList
    override val resourceArn: __string = impl.resourceArn(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.Alert
  ): zio.aws.mediatailor.model.Alert.ReadOnly = new Wrapper(impl)
}
