package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateLiveSourceRequest(
    httpPackageConfigurations: Iterable[
      zio.aws.mediatailor.model.HttpPackageConfiguration
    ],
    liveSourceName: __string,
    sourceLocationName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.UpdateLiveSourceRequest = {
    import UpdateLiveSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.UpdateLiveSourceRequest
      .builder()
      .httpPackageConfigurations(httpPackageConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .liveSourceName(liveSourceName: java.lang.String)
      .sourceLocationName(sourceLocationName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.UpdateLiveSourceRequest.ReadOnly =
    zio.aws.mediatailor.model.UpdateLiveSourceRequest.wrap(buildAwsValue())
}
object UpdateLiveSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.UpdateLiveSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.UpdateLiveSourceRequest =
      zio.aws.mediatailor.model.UpdateLiveSourceRequest(
        httpPackageConfigurations.map { item =>
          item.asEditable
        },
        liveSourceName,
        sourceLocationName
      )
    def httpPackageConfigurations
        : List[zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly]
    def liveSourceName: __string
    def sourceLocationName: __string
    def getHttpPackageConfigurations: ZIO[Any, Nothing, List[
      zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly
    ]] = ZIO.succeed(httpPackageConfigurations)
    def getLiveSourceName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(liveSourceName)
    def getSourceLocationName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(sourceLocationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.UpdateLiveSourceRequest
  ) extends zio.aws.mediatailor.model.UpdateLiveSourceRequest.ReadOnly {
    override val httpPackageConfigurations
        : List[zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly] =
      impl
        .httpPackageConfigurations()
        .asScala
        .map { item =>
          zio.aws.mediatailor.model.HttpPackageConfiguration.wrap(item)
        }
        .toList
    override val liveSourceName: __string = impl.liveSourceName(): __string
    override val sourceLocationName: __string =
      impl.sourceLocationName(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.UpdateLiveSourceRequest
  ): zio.aws.mediatailor.model.UpdateLiveSourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
