package zio.aws.mediatailor.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediatailor.model.primitives.__integer
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SpliceInsertMessage(
    availNum: Optional[__integer] = Optional.Absent,
    availsExpected: Optional[__integer] = Optional.Absent,
    spliceEventId: Optional[__integer] = Optional.Absent,
    uniqueProgramId: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.SpliceInsertMessage = {
    import SpliceInsertMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.SpliceInsertMessage
      .builder()
      .optionallyWith(availNum.map(value => value: Integer))(_.availNum)
      .optionallyWith(availsExpected.map(value => value: Integer))(
        _.availsExpected
      )
      .optionallyWith(spliceEventId.map(value => value: Integer))(
        _.spliceEventId
      )
      .optionallyWith(uniqueProgramId.map(value => value: Integer))(
        _.uniqueProgramId
      )
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.SpliceInsertMessage.ReadOnly =
    zio.aws.mediatailor.model.SpliceInsertMessage.wrap(buildAwsValue())
}
object SpliceInsertMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.SpliceInsertMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.SpliceInsertMessage =
      zio.aws.mediatailor.model.SpliceInsertMessage(
        availNum.map(value => value),
        availsExpected.map(value => value),
        spliceEventId.map(value => value),
        uniqueProgramId.map(value => value)
      )
    def availNum: Optional[__integer]
    def availsExpected: Optional[__integer]
    def spliceEventId: Optional[__integer]
    def uniqueProgramId: Optional[__integer]
    def getAvailNum: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("availNum", availNum)
    def getAvailsExpected: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("availsExpected", availsExpected)
    def getSpliceEventId: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("spliceEventId", spliceEventId)
    def getUniqueProgramId: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("uniqueProgramId", uniqueProgramId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.SpliceInsertMessage
  ) extends zio.aws.mediatailor.model.SpliceInsertMessage.ReadOnly {
    override val availNum: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.availNum())
      .map(value => value: __integer)
    override val availsExpected: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.availsExpected())
      .map(value => value: __integer)
    override val spliceEventId: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.spliceEventId())
      .map(value => value: __integer)
    override val uniqueProgramId: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.uniqueProgramId())
      .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.SpliceInsertMessage
  ): zio.aws.mediatailor.model.SpliceInsertMessage.ReadOnly = new Wrapper(impl)
}
