package zio.aws.mediatailor.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediatailor.model.primitives.{__string, MaxResults}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListVodSourcesRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent,
    sourceLocationName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest = {
    import ListVodSourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .sourceLocationName(sourceLocationName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.ListVodSourcesRequest.ReadOnly =
    zio.aws.mediatailor.model.ListVodSourcesRequest.wrap(buildAwsValue())
}
object ListVodSourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.ListVodSourcesRequest =
      zio.aws.mediatailor.model.ListVodSourcesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        sourceLocationName
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[__string]
    def sourceLocationName: __string
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSourceLocationName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(sourceLocationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest
  ) extends zio.aws.mediatailor.model.ListVodSourcesRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.mediatailor.model.primitives.MaxResults(value))
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val sourceLocationName: __string =
      impl.sourceLocationName(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest
  ): zio.aws.mediatailor.model.ListVodSourcesRequest.ReadOnly = new Wrapper(
    impl
  )
}
