package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.{__long, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Transition(
    relativePosition: zio.aws.mediatailor.model.RelativePosition,
    relativeProgram: Optional[__string] = Optional.Absent,
    scheduledStartTimeMillis: Optional[__long] = Optional.Absent,
    `type`: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.Transition = {
    import Transition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.Transition
      .builder()
      .relativePosition(relativePosition.unwrap)
      .optionallyWith(relativeProgram.map(value => value: java.lang.String))(
        _.relativeProgram
      )
      .optionallyWith(
        scheduledStartTimeMillis.map(value => value: java.lang.Long)
      )(_.scheduledStartTimeMillis)
      .`type`(`type`: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.Transition.ReadOnly =
    zio.aws.mediatailor.model.Transition.wrap(buildAwsValue())
}
object Transition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.Transition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.Transition =
      zio.aws.mediatailor.model.Transition(
        relativePosition,
        relativeProgram.map(value => value),
        scheduledStartTimeMillis.map(value => value),
        `type`
      )
    def relativePosition: zio.aws.mediatailor.model.RelativePosition
    def relativeProgram: Optional[__string]
    def scheduledStartTimeMillis: Optional[__long]
    def `type`: __string
    def getRelativePosition
        : ZIO[Any, Nothing, zio.aws.mediatailor.model.RelativePosition] =
      ZIO.succeed(relativePosition)
    def getRelativeProgram: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("relativeProgram", relativeProgram)
    def getScheduledStartTimeMillis: ZIO[Any, AwsError, __long] = AwsError
      .unwrapOptionField("scheduledStartTimeMillis", scheduledStartTimeMillis)
    def getType: ZIO[Any, Nothing, __string] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.Transition
  ) extends zio.aws.mediatailor.model.Transition.ReadOnly {
    override val relativePosition: zio.aws.mediatailor.model.RelativePosition =
      zio.aws.mediatailor.model.RelativePosition.wrap(impl.relativePosition())
    override val relativeProgram: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.relativeProgram())
      .map(value => value: __string)
    override val scheduledStartTimeMillis: Optional[__long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledStartTimeMillis())
        .map(value => value: __long)
    override val `type`: __string = impl.`type`(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.Transition
  ): zio.aws.mediatailor.model.Transition.ReadOnly = new Wrapper(impl)
}
