package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PrefetchSchedule(
    arn: __string,
    consumption: zio.aws.mediatailor.model.PrefetchConsumption,
    name: __string,
    playbackConfigurationName: __string,
    retrieval: zio.aws.mediatailor.model.PrefetchRetrieval,
    streamId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.PrefetchSchedule = {
    import PrefetchSchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.PrefetchSchedule
      .builder()
      .arn(arn: java.lang.String)
      .consumption(consumption.buildAwsValue())
      .name(name: java.lang.String)
      .playbackConfigurationName(playbackConfigurationName: java.lang.String)
      .retrieval(retrieval.buildAwsValue())
      .optionallyWith(streamId.map(value => value: java.lang.String))(
        _.streamId
      )
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.PrefetchSchedule.ReadOnly =
    zio.aws.mediatailor.model.PrefetchSchedule.wrap(buildAwsValue())
}
object PrefetchSchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.PrefetchSchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.PrefetchSchedule =
      zio.aws.mediatailor.model.PrefetchSchedule(
        arn,
        consumption.asEditable,
        name,
        playbackConfigurationName,
        retrieval.asEditable,
        streamId.map(value => value)
      )
    def arn: __string
    def consumption: zio.aws.mediatailor.model.PrefetchConsumption.ReadOnly
    def name: __string
    def playbackConfigurationName: __string
    def retrieval: zio.aws.mediatailor.model.PrefetchRetrieval.ReadOnly
    def streamId: Optional[__string]
    def getArn: ZIO[Any, Nothing, __string] = ZIO.succeed(arn)
    def getConsumption: ZIO[
      Any,
      Nothing,
      zio.aws.mediatailor.model.PrefetchConsumption.ReadOnly
    ] = ZIO.succeed(consumption)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getPlaybackConfigurationName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(playbackConfigurationName)
    def getRetrieval: ZIO[
      Any,
      Nothing,
      zio.aws.mediatailor.model.PrefetchRetrieval.ReadOnly
    ] = ZIO.succeed(retrieval)
    def getStreamId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("streamId", streamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.PrefetchSchedule
  ) extends zio.aws.mediatailor.model.PrefetchSchedule.ReadOnly {
    override val arn: __string = impl.arn(): __string
    override val consumption
        : zio.aws.mediatailor.model.PrefetchConsumption.ReadOnly =
      zio.aws.mediatailor.model.PrefetchConsumption.wrap(impl.consumption())
    override val name: __string = impl.name(): __string
    override val playbackConfigurationName: __string =
      impl.playbackConfigurationName(): __string
    override val retrieval
        : zio.aws.mediatailor.model.PrefetchRetrieval.ReadOnly =
      zio.aws.mediatailor.model.PrefetchRetrieval.wrap(impl.retrieval())
    override val streamId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.streamId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.PrefetchSchedule
  ): zio.aws.mediatailor.model.PrefetchSchedule.ReadOnly = new Wrapper(impl)
}
