package zio.aws.mediatailor.model
import scala.jdk.CollectionConverters.*
sealed trait PlaybackMode {
  def unwrap: software.amazon.awssdk.services.mediatailor.model.PlaybackMode
}
object PlaybackMode {
  def wrap(
      value: software.amazon.awssdk.services.mediatailor.model.PlaybackMode
  ): zio.aws.mediatailor.model.PlaybackMode = value match {
    case software.amazon.awssdk.services.mediatailor.model.PlaybackMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediatailor.model.PlaybackMode.LOOP =>
      val r = LOOP
      r
    case software.amazon.awssdk.services.mediatailor.model.PlaybackMode.LINEAR =>
      val r = LINEAR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediatailor.model.PlaybackMode {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.PlaybackMode =
      software.amazon.awssdk.services.mediatailor.model.PlaybackMode.UNKNOWN_TO_SDK_VERSION
  }
  case object LOOP extends zio.aws.mediatailor.model.PlaybackMode {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.PlaybackMode =
      software.amazon.awssdk.services.mediatailor.model.PlaybackMode.LOOP
  }
  case object LINEAR extends zio.aws.mediatailor.model.PlaybackMode {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.PlaybackMode =
      software.amazon.awssdk.services.mediatailor.model.PlaybackMode.LINEAR
  }
}
