package zio.aws.mediatailor.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediatailor.model.primitives.{__timestampUnix, __string}
import scala.jdk.CollectionConverters.*
final case class DescribeProgramResponse(
    adBreaks: Optional[Iterable[zio.aws.mediatailor.model.AdBreak]] =
      Optional.Absent,
    arn: Optional[__string] = Optional.Absent,
    channelName: Optional[__string] = Optional.Absent,
    creationTime: Optional[__timestampUnix] = Optional.Absent,
    programName: Optional[__string] = Optional.Absent,
    scheduledStartTime: Optional[__timestampUnix] = Optional.Absent,
    sourceLocationName: Optional[__string] = Optional.Absent,
    vodSourceName: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.DescribeProgramResponse = {
    import DescribeProgramResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.DescribeProgramResponse
      .builder()
      .optionallyWith(
        adBreaks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.adBreaks)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(channelName.map(value => value: java.lang.String))(
        _.channelName
      )
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(programName.map(value => value: java.lang.String))(
        _.programName
      )
      .optionallyWith(scheduledStartTime.map(value => value: Instant))(
        _.scheduledStartTime
      )
      .optionallyWith(sourceLocationName.map(value => value: java.lang.String))(
        _.sourceLocationName
      )
      .optionallyWith(vodSourceName.map(value => value: java.lang.String))(
        _.vodSourceName
      )
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.DescribeProgramResponse.ReadOnly =
    zio.aws.mediatailor.model.DescribeProgramResponse.wrap(buildAwsValue())
}
object DescribeProgramResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.DescribeProgramResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.DescribeProgramResponse =
      zio.aws.mediatailor.model.DescribeProgramResponse(
        adBreaks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        arn.map(value => value),
        channelName.map(value => value),
        creationTime.map(value => value),
        programName.map(value => value),
        scheduledStartTime.map(value => value),
        sourceLocationName.map(value => value),
        vodSourceName.map(value => value)
      )
    def adBreaks: Optional[List[zio.aws.mediatailor.model.AdBreak.ReadOnly]]
    def arn: Optional[__string]
    def channelName: Optional[__string]
    def creationTime: Optional[__timestampUnix]
    def programName: Optional[__string]
    def scheduledStartTime: Optional[__timestampUnix]
    def sourceLocationName: Optional[__string]
    def vodSourceName: Optional[__string]
    def getAdBreaks
        : ZIO[Any, AwsError, List[zio.aws.mediatailor.model.AdBreak.ReadOnly]] =
      AwsError.unwrapOptionField("adBreaks", adBreaks)
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getChannelName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("channelName", channelName)
    def getCreationTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getProgramName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("programName", programName)
    def getScheduledStartTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("scheduledStartTime", scheduledStartTime)
    def getSourceLocationName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceLocationName", sourceLocationName)
    def getVodSourceName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("vodSourceName", vodSourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.DescribeProgramResponse
  ) extends zio.aws.mediatailor.model.DescribeProgramResponse.ReadOnly {
    override val adBreaks
        : Optional[List[zio.aws.mediatailor.model.AdBreak.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adBreaks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediatailor.model.AdBreak.wrap(item)
          }.toList
        )
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val channelName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.channelName())
      .map(value => value: __string)
    override val creationTime: Optional[__timestampUnix] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => value: __timestampUnix)
    override val programName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.programName())
      .map(value => value: __string)
    override val scheduledStartTime: Optional[__timestampUnix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledStartTime())
        .map(value => value: __timestampUnix)
    override val sourceLocationName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceLocationName())
      .map(value => value: __string)
    override val vodSourceName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.vodSourceName())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.DescribeProgramResponse
  ): zio.aws.mediatailor.model.DescribeProgramResponse.ReadOnly = new Wrapper(
    impl
  )
}
