package zio.aws.mediatailor.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediatailor.model.primitives.{__timestampUnix, __string}
import scala.jdk.CollectionConverters.*
final case class Channel(
    arn: __string,
    channelName: __string,
    channelState: __string,
    creationTime: Optional[__timestampUnix] = Optional.Absent,
    fillerSlate: Optional[zio.aws.mediatailor.model.SlateSource] =
      Optional.Absent,
    lastModifiedTime: Optional[__timestampUnix] = Optional.Absent,
    outputs: Iterable[zio.aws.mediatailor.model.ResponseOutputItem],
    playbackMode: __string,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.Channel = {
    import Channel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.Channel
      .builder()
      .arn(arn: java.lang.String)
      .channelName(channelName: java.lang.String)
      .channelState(channelState: java.lang.String)
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(fillerSlate.map(value => value.buildAwsValue()))(
        _.fillerSlate
      )
      .optionallyWith(lastModifiedTime.map(value => value: Instant))(
        _.lastModifiedTime
      )
      .outputs(outputs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .playbackMode(playbackMode: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.Channel.ReadOnly =
    zio.aws.mediatailor.model.Channel.wrap(buildAwsValue())
}
object Channel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.Channel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.Channel =
      zio.aws.mediatailor.model.Channel(
        arn,
        channelName,
        channelState,
        creationTime.map(value => value),
        fillerSlate.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        outputs.map { item =>
          item.asEditable
        },
        playbackMode,
        tags.map(value => value)
      )
    def arn: __string
    def channelName: __string
    def channelState: __string
    def creationTime: Optional[__timestampUnix]
    def fillerSlate: Optional[zio.aws.mediatailor.model.SlateSource.ReadOnly]
    def lastModifiedTime: Optional[__timestampUnix]
    def outputs: List[zio.aws.mediatailor.model.ResponseOutputItem.ReadOnly]
    def playbackMode: __string
    def tags: Optional[Map[__string, __string]]
    def getArn: ZIO[Any, Nothing, __string] = ZIO.succeed(arn)
    def getChannelName: ZIO[Any, Nothing, __string] = ZIO.succeed(channelName)
    def getChannelState: ZIO[Any, Nothing, __string] = ZIO.succeed(channelState)
    def getCreationTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getFillerSlate
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.SlateSource.ReadOnly] =
      AwsError.unwrapOptionField("fillerSlate", fillerSlate)
    def getLastModifiedTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getOutputs: ZIO[Any, Nothing, List[
      zio.aws.mediatailor.model.ResponseOutputItem.ReadOnly
    ]] = ZIO.succeed(outputs)
    def getPlaybackMode: ZIO[Any, Nothing, __string] = ZIO.succeed(playbackMode)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.Channel
  ) extends zio.aws.mediatailor.model.Channel.ReadOnly {
    override val arn: __string = impl.arn(): __string
    override val channelName: __string = impl.channelName(): __string
    override val channelState: __string = impl.channelState(): __string
    override val creationTime: Optional[__timestampUnix] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => value: __timestampUnix)
    override val fillerSlate
        : Optional[zio.aws.mediatailor.model.SlateSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fillerSlate())
        .map(value => zio.aws.mediatailor.model.SlateSource.wrap(value))
    override val lastModifiedTime: Optional[__timestampUnix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value => value: __timestampUnix)
    override val outputs
        : List[zio.aws.mediatailor.model.ResponseOutputItem.ReadOnly] = impl
      .outputs()
      .asScala
      .map { item =>
        zio.aws.mediatailor.model.ResponseOutputItem.wrap(item)
      }
      .toList
    override val playbackMode: __string = impl.playbackMode(): __string
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.Channel
  ): zio.aws.mediatailor.model.Channel.ReadOnly = new Wrapper(impl)
}
