package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.{__timestampUnix, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class UpdateChannelResponse(
    arn: Option[__string] = None,
    channelName: Option[__string] = None,
    channelState: Option[zio.aws.mediatailor.model.ChannelState] = None,
    creationTime: Option[__timestampUnix] = None,
    fillerSlate: Option[zio.aws.mediatailor.model.SlateSource] = None,
    lastModifiedTime: Option[__timestampUnix] = None,
    outputs: Option[Iterable[zio.aws.mediatailor.model.ResponseOutputItem]] =
      None,
    playbackMode: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.UpdateChannelResponse = {
    import UpdateChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.UpdateChannelResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(channelName.map(value => value: java.lang.String))(
        _.channelName
      )
      .optionallyWith(channelState.map(value => value.unwrap))(_.channelState)
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(fillerSlate.map(value => value.buildAwsValue()))(
        _.fillerSlate
      )
      .optionallyWith(lastModifiedTime.map(value => value: Instant))(
        _.lastModifiedTime
      )
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .optionallyWith(playbackMode.map(value => value: java.lang.String))(
        _.playbackMode
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.UpdateChannelResponse.ReadOnly =
    zio.aws.mediatailor.model.UpdateChannelResponse.wrap(buildAwsValue())
}
object UpdateChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.UpdateChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.UpdateChannelResponse =
      zio.aws.mediatailor.model.UpdateChannelResponse(
        arn.map(value => value),
        channelName.map(value => value),
        channelState.map(value => value),
        creationTime.map(value => value),
        fillerSlate.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        outputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        playbackMode.map(value => value),
        tags.map(value => value)
      )
    def arn: Option[__string]
    def channelName: Option[__string]
    def channelState: Option[zio.aws.mediatailor.model.ChannelState]
    def creationTime: Option[__timestampUnix]
    def fillerSlate: Option[zio.aws.mediatailor.model.SlateSource.ReadOnly]
    def lastModifiedTime: Option[__timestampUnix]
    def outputs
        : Option[List[zio.aws.mediatailor.model.ResponseOutputItem.ReadOnly]]
    def playbackMode: Option[__string]
    def tags: Option[Map[__string, __string]]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getChannelName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("channelName", channelName)
    def getChannelState
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.ChannelState] =
      AwsError.unwrapOptionField("channelState", channelState)
    def getCreationTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getFillerSlate
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.SlateSource.ReadOnly] =
      AwsError.unwrapOptionField("fillerSlate", fillerSlate)
    def getLastModifiedTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getOutputs: ZIO[Any, AwsError, List[
      zio.aws.mediatailor.model.ResponseOutputItem.ReadOnly
    ]] = AwsError.unwrapOptionField("outputs", outputs)
    def getPlaybackMode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("playbackMode", playbackMode)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.UpdateChannelResponse
  ) extends zio.aws.mediatailor.model.UpdateChannelResponse.ReadOnly {
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val channelName: Option[__string] =
      scala.Option(impl.channelName()).map(value => value: __string)
    override val channelState: Option[zio.aws.mediatailor.model.ChannelState] =
      scala
        .Option(impl.channelState())
        .map(value => zio.aws.mediatailor.model.ChannelState.wrap(value))
    override val creationTime: Option[__timestampUnix] =
      scala.Option(impl.creationTime()).map(value => value: __timestampUnix)
    override val fillerSlate
        : Option[zio.aws.mediatailor.model.SlateSource.ReadOnly] = scala
      .Option(impl.fillerSlate())
      .map(value => zio.aws.mediatailor.model.SlateSource.wrap(value))
    override val lastModifiedTime: Option[__timestampUnix] =
      scala.Option(impl.lastModifiedTime()).map(value => value: __timestampUnix)
    override val outputs
        : Option[List[zio.aws.mediatailor.model.ResponseOutputItem.ReadOnly]] =
      scala
        .Option(impl.outputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediatailor.model.ResponseOutputItem.wrap(item)
          }.toList
        )
    override val playbackMode: Option[__string] =
      scala.Option(impl.playbackMode()).map(value => value: __string)
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.UpdateChannelResponse
  ): zio.aws.mediatailor.model.UpdateChannelResponse.ReadOnly = new Wrapper(
    impl
  )
}
