package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.{__long, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Transition(
    relativePosition: zio.aws.mediatailor.model.RelativePosition,
    relativeProgram: Option[__string] = None,
    scheduledStartTimeMillis: Option[__long] = None,
    `type`: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.Transition = {
    import Transition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.Transition
      .builder()
      .relativePosition(relativePosition.unwrap)
      .optionallyWith(relativeProgram.map(value => value: java.lang.String))(
        _.relativeProgram
      )
      .optionallyWith(
        scheduledStartTimeMillis.map(value => value: java.lang.Long)
      )(_.scheduledStartTimeMillis)
      .`type`(`type`: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.Transition.ReadOnly =
    zio.aws.mediatailor.model.Transition.wrap(buildAwsValue())
}
object Transition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.Transition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.Transition =
      zio.aws.mediatailor.model.Transition(
        relativePosition,
        relativeProgram.map(value => value),
        scheduledStartTimeMillis.map(value => value),
        `type`
      )
    def relativePosition: zio.aws.mediatailor.model.RelativePosition
    def relativeProgram: Option[__string]
    def scheduledStartTimeMillis: Option[__long]
    def `type`: __string
    def getRelativePosition
        : ZIO[Any, Nothing, zio.aws.mediatailor.model.RelativePosition] =
      ZIO.succeed(relativePosition)
    def getRelativeProgram: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("relativeProgram", relativeProgram)
    def getScheduledStartTimeMillis: ZIO[Any, AwsError, __long] = AwsError
      .unwrapOptionField("scheduledStartTimeMillis", scheduledStartTimeMillis)
    def getType: ZIO[Any, Nothing, __string] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.Transition
  ) extends zio.aws.mediatailor.model.Transition.ReadOnly {
    override val relativePosition: zio.aws.mediatailor.model.RelativePosition =
      zio.aws.mediatailor.model.RelativePosition.wrap(impl.relativePosition())
    override val relativeProgram: Option[__string] =
      scala.Option(impl.relativeProgram()).map(value => value: __string)
    override val scheduledStartTimeMillis: Option[__long] =
      scala.Option(impl.scheduledStartTimeMillis()).map(value => value: __long)
    override val `type`: __string = impl.`type`(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.Transition
  ): zio.aws.mediatailor.model.Transition.ReadOnly = new Wrapper(impl)
}
