package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.{__string, __timestampUnix, __long}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ScheduleAdBreak(
    approximateDurationSeconds: Option[__long] = None,
    approximateStartTime: Option[__timestampUnix] = None,
    sourceLocationName: Option[__string] = None,
    vodSourceName: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ScheduleAdBreak = {
    import ScheduleAdBreak.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ScheduleAdBreak
      .builder()
      .optionallyWith(
        approximateDurationSeconds.map(value => value: java.lang.Long)
      )(_.approximateDurationSeconds)
      .optionallyWith(approximateStartTime.map(value => value: Instant))(
        _.approximateStartTime
      )
      .optionallyWith(sourceLocationName.map(value => value: java.lang.String))(
        _.sourceLocationName
      )
      .optionallyWith(vodSourceName.map(value => value: java.lang.String))(
        _.vodSourceName
      )
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.ScheduleAdBreak.ReadOnly =
    zio.aws.mediatailor.model.ScheduleAdBreak.wrap(buildAwsValue())
}
object ScheduleAdBreak {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ScheduleAdBreak
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.ScheduleAdBreak =
      zio.aws.mediatailor.model.ScheduleAdBreak(
        approximateDurationSeconds.map(value => value),
        approximateStartTime.map(value => value),
        sourceLocationName.map(value => value),
        vodSourceName.map(value => value)
      )
    def approximateDurationSeconds: Option[__long]
    def approximateStartTime: Option[__timestampUnix]
    def sourceLocationName: Option[__string]
    def vodSourceName: Option[__string]
    def getApproximateDurationSeconds: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField(
        "approximateDurationSeconds",
        approximateDurationSeconds
      )
    def getApproximateStartTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("approximateStartTime", approximateStartTime)
    def getSourceLocationName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceLocationName", sourceLocationName)
    def getVodSourceName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("vodSourceName", vodSourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ScheduleAdBreak
  ) extends zio.aws.mediatailor.model.ScheduleAdBreak.ReadOnly {
    override val approximateDurationSeconds: Option[__long] = scala
      .Option(impl.approximateDurationSeconds())
      .map(value => value: __long)
    override val approximateStartTime: Option[__timestampUnix] = scala
      .Option(impl.approximateStartTime())
      .map(value => value: __timestampUnix)
    override val sourceLocationName: Option[__string] =
      scala.Option(impl.sourceLocationName()).map(value => value: __string)
    override val vodSourceName: Option[__string] =
      scala.Option(impl.vodSourceName()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ScheduleAdBreak
  ): zio.aws.mediatailor.model.ScheduleAdBreak.ReadOnly = new Wrapper(impl)
}
