package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__timestampUnix
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class PrefetchConsumption(
    availMatchingCriteria: Option[
      Iterable[zio.aws.mediatailor.model.AvailMatchingCriteria]
    ] = None,
    endTime: __timestampUnix,
    startTime: Option[__timestampUnix] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.PrefetchConsumption = {
    import PrefetchConsumption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.PrefetchConsumption
      .builder()
      .optionallyWith(
        availMatchingCriteria.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availMatchingCriteria)
      .endTime(endTime: Instant)
      .optionallyWith(startTime.map(value => value: Instant))(_.startTime)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.PrefetchConsumption.ReadOnly =
    zio.aws.mediatailor.model.PrefetchConsumption.wrap(buildAwsValue())
}
object PrefetchConsumption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.PrefetchConsumption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.PrefetchConsumption =
      zio.aws.mediatailor.model.PrefetchConsumption(
        availMatchingCriteria.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        endTime,
        startTime.map(value => value)
      )
    def availMatchingCriteria
        : Option[List[zio.aws.mediatailor.model.AvailMatchingCriteria.ReadOnly]]
    def endTime: __timestampUnix
    def startTime: Option[__timestampUnix]
    def getAvailMatchingCriteria: ZIO[Any, AwsError, List[
      zio.aws.mediatailor.model.AvailMatchingCriteria.ReadOnly
    ]] =
      AwsError.unwrapOptionField("availMatchingCriteria", availMatchingCriteria)
    def getEndTime: ZIO[Any, Nothing, __timestampUnix] = ZIO.succeed(endTime)
    def getStartTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("startTime", startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.PrefetchConsumption
  ) extends zio.aws.mediatailor.model.PrefetchConsumption.ReadOnly {
    override val availMatchingCriteria: Option[
      List[zio.aws.mediatailor.model.AvailMatchingCriteria.ReadOnly]
    ] = scala
      .Option(impl.availMatchingCriteria())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediatailor.model.AvailMatchingCriteria.wrap(item)
        }.toList
      )
    override val endTime: __timestampUnix = impl.endTime(): __timestampUnix
    override val startTime: Option[__timestampUnix] =
      scala.Option(impl.startTime()).map(value => value: __timestampUnix)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.PrefetchConsumption
  ): zio.aws.mediatailor.model.PrefetchConsumption.ReadOnly = new Wrapper(impl)
}
