package zio.aws.mediatailor.model
import java.lang.Integer
import zio.aws.mediatailor.model.primitives.{__string, MaxResults}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListVodSourcesRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None,
    sourceLocationName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest = {
    import ListVodSourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .sourceLocationName(sourceLocationName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.ListVodSourcesRequest.ReadOnly =
    zio.aws.mediatailor.model.ListVodSourcesRequest.wrap(buildAwsValue())
}
object ListVodSourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.ListVodSourcesRequest =
      zio.aws.mediatailor.model.ListVodSourcesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        sourceLocationName
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def sourceLocationName: __string
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSourceLocationName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(sourceLocationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest
  ) extends zio.aws.mediatailor.model.ListVodSourcesRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.mediatailor.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
    override val sourceLocationName: __string =
      impl.sourceLocationName(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ListVodSourcesRequest
  ): zio.aws.mediatailor.model.ListVodSourcesRequest.ReadOnly = new Wrapper(
    impl
  )
}
