package zio.aws.mediatailor.model
import java.lang.Integer
import zio.aws.mediatailor.model.primitives.{__string, MaxResults}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAlertsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None,
    resourceArn: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ListAlertsRequest = {
    import ListAlertsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ListAlertsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .resourceArn(resourceArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.ListAlertsRequest.ReadOnly =
    zio.aws.mediatailor.model.ListAlertsRequest.wrap(buildAwsValue())
}
object ListAlertsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ListAlertsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.ListAlertsRequest =
      zio.aws.mediatailor.model.ListAlertsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        resourceArn
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def resourceArn: __string
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResourceArn: ZIO[Any, Nothing, __string] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ListAlertsRequest
  ) extends zio.aws.mediatailor.model.ListAlertsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.mediatailor.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
    override val resourceArn: __string = impl.resourceArn(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ListAlertsRequest
  ): zio.aws.mediatailor.model.ListAlertsRequest.ReadOnly = new Wrapper(impl)
}
