package zio.aws.mediatailor.model
import java.lang.Integer
import zio.aws.mediatailor.model.primitives.__integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HlsPlaylistSettings(
    manifestWindowSeconds: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.HlsPlaylistSettings = {
    import HlsPlaylistSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.HlsPlaylistSettings
      .builder()
      .optionallyWith(manifestWindowSeconds.map(value => value: Integer))(
        _.manifestWindowSeconds
      )
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.HlsPlaylistSettings.ReadOnly =
    zio.aws.mediatailor.model.HlsPlaylistSettings.wrap(buildAwsValue())
}
object HlsPlaylistSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.HlsPlaylistSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.HlsPlaylistSettings =
      zio.aws.mediatailor.model
        .HlsPlaylistSettings(manifestWindowSeconds.map(value => value))
    def manifestWindowSeconds: Option[__integer]
    def getManifestWindowSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("manifestWindowSeconds", manifestWindowSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.HlsPlaylistSettings
  ) extends zio.aws.mediatailor.model.HlsPlaylistSettings.ReadOnly {
    override val manifestWindowSeconds: Option[__integer] =
      scala.Option(impl.manifestWindowSeconds()).map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.HlsPlaylistSettings
  ): zio.aws.mediatailor.model.HlsPlaylistSettings.ReadOnly = new Wrapper(impl)
}
