package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DashConfigurationForPut(
    mpdLocation: Option[__string] = None,
    originManifestType: Option[zio.aws.mediatailor.model.OriginManifestType] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.DashConfigurationForPut = {
    import DashConfigurationForPut.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.DashConfigurationForPut
      .builder()
      .optionallyWith(mpdLocation.map(value => value: java.lang.String))(
        _.mpdLocation
      )
      .optionallyWith(originManifestType.map(value => value.unwrap))(
        _.originManifestType
      )
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.DashConfigurationForPut.ReadOnly =
    zio.aws.mediatailor.model.DashConfigurationForPut.wrap(buildAwsValue())
}
object DashConfigurationForPut {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.DashConfigurationForPut
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.DashConfigurationForPut =
      zio.aws.mediatailor.model.DashConfigurationForPut(
        mpdLocation.map(value => value),
        originManifestType.map(value => value)
      )
    def mpdLocation: Option[__string]
    def originManifestType: Option[zio.aws.mediatailor.model.OriginManifestType]
    def getMpdLocation: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("mpdLocation", mpdLocation)
    def getOriginManifestType
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.OriginManifestType] =
      AwsError.unwrapOptionField("originManifestType", originManifestType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.DashConfigurationForPut
  ) extends zio.aws.mediatailor.model.DashConfigurationForPut.ReadOnly {
    override val mpdLocation: Option[__string] =
      scala.Option(impl.mpdLocation()).map(value => value: __string)
    override val originManifestType
        : Option[zio.aws.mediatailor.model.OriginManifestType] = scala
      .Option(impl.originManifestType())
      .map(value => zio.aws.mediatailor.model.OriginManifestType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.DashConfigurationForPut
  ): zio.aws.mediatailor.model.DashConfigurationForPut.ReadOnly = new Wrapper(
    impl
  )
}
