package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateVodSourceRequest(
    httpPackageConfigurations: Iterable[
      zio.aws.mediatailor.model.HttpPackageConfiguration
    ],
    sourceLocationName: __string,
    tags: Option[Map[__string, __string]] = None,
    vodSourceName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.CreateVodSourceRequest = {
    import CreateVodSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.CreateVodSourceRequest
      .builder()
      .httpPackageConfigurations(httpPackageConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .sourceLocationName(sourceLocationName: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .vodSourceName(vodSourceName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.CreateVodSourceRequest.ReadOnly =
    zio.aws.mediatailor.model.CreateVodSourceRequest.wrap(buildAwsValue())
}
object CreateVodSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.CreateVodSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.CreateVodSourceRequest =
      zio.aws.mediatailor.model.CreateVodSourceRequest(
        httpPackageConfigurations.map { item =>
          item.asEditable
        },
        sourceLocationName,
        tags.map(value => value),
        vodSourceName
      )
    def httpPackageConfigurations
        : List[zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly]
    def sourceLocationName: __string
    def tags: Option[Map[__string, __string]]
    def vodSourceName: __string
    def getHttpPackageConfigurations: ZIO[Any, Nothing, List[
      zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly
    ]] = ZIO.succeed(httpPackageConfigurations)
    def getSourceLocationName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(sourceLocationName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVodSourceName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(vodSourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateVodSourceRequest
  ) extends zio.aws.mediatailor.model.CreateVodSourceRequest.ReadOnly {
    override val httpPackageConfigurations
        : List[zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly] =
      impl
        .httpPackageConfigurations()
        .asScala
        .map { item =>
          zio.aws.mediatailor.model.HttpPackageConfiguration.wrap(item)
        }
        .toList
    override val sourceLocationName: __string =
      impl.sourceLocationName(): __string
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val vodSourceName: __string = impl.vodSourceName(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateVodSourceRequest
  ): zio.aws.mediatailor.model.CreateVodSourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
