package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.{__timestampUnix, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CreateSourceLocationResponse(
    accessConfiguration: Option[zio.aws.mediatailor.model.AccessConfiguration] =
      None,
    arn: Option[__string] = None,
    creationTime: Option[__timestampUnix] = None,
    defaultSegmentDeliveryConfiguration: Option[
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration
    ] = None,
    httpConfiguration: Option[zio.aws.mediatailor.model.HttpConfiguration] =
      None,
    lastModifiedTime: Option[__timestampUnix] = None,
    segmentDeliveryConfigurations: Option[
      Iterable[zio.aws.mediatailor.model.SegmentDeliveryConfiguration]
    ] = None,
    sourceLocationName: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.CreateSourceLocationResponse = {
    import CreateSourceLocationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.CreateSourceLocationResponse
      .builder()
      .optionallyWith(accessConfiguration.map(value => value.buildAwsValue()))(
        _.accessConfiguration
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(
        defaultSegmentDeliveryConfiguration.map(value => value.buildAwsValue())
      )(_.defaultSegmentDeliveryConfiguration)
      .optionallyWith(httpConfiguration.map(value => value.buildAwsValue()))(
        _.httpConfiguration
      )
      .optionallyWith(lastModifiedTime.map(value => value: Instant))(
        _.lastModifiedTime
      )
      .optionallyWith(
        segmentDeliveryConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.segmentDeliveryConfigurations)
      .optionallyWith(sourceLocationName.map(value => value: java.lang.String))(
        _.sourceLocationName
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.CreateSourceLocationResponse.ReadOnly =
    zio.aws.mediatailor.model.CreateSourceLocationResponse.wrap(buildAwsValue())
}
object CreateSourceLocationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.CreateSourceLocationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.CreateSourceLocationResponse =
      zio.aws.mediatailor.model.CreateSourceLocationResponse(
        accessConfiguration.map(value => value.asEditable),
        arn.map(value => value),
        creationTime.map(value => value),
        defaultSegmentDeliveryConfiguration.map(value => value.asEditable),
        httpConfiguration.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        segmentDeliveryConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceLocationName.map(value => value),
        tags.map(value => value)
      )
    def accessConfiguration
        : Option[zio.aws.mediatailor.model.AccessConfiguration.ReadOnly]
    def arn: Option[__string]
    def creationTime: Option[__timestampUnix]
    def defaultSegmentDeliveryConfiguration: Option[
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly
    ]
    def httpConfiguration
        : Option[zio.aws.mediatailor.model.HttpConfiguration.ReadOnly]
    def lastModifiedTime: Option[__timestampUnix]
    def segmentDeliveryConfigurations: Option[
      List[zio.aws.mediatailor.model.SegmentDeliveryConfiguration.ReadOnly]
    ]
    def sourceLocationName: Option[__string]
    def tags: Option[Map[__string, __string]]
    def getAccessConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.AccessConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("accessConfiguration", accessConfiguration)
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDefaultSegmentDeliveryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultSegmentDeliveryConfiguration",
      defaultSegmentDeliveryConfiguration
    )
    def getHttpConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.HttpConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("httpConfiguration", httpConfiguration)
    def getLastModifiedTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getSegmentDeliveryConfigurations: ZIO[Any, AwsError, List[
      zio.aws.mediatailor.model.SegmentDeliveryConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "segmentDeliveryConfigurations",
      segmentDeliveryConfigurations
    )
    def getSourceLocationName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceLocationName", sourceLocationName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateSourceLocationResponse
  ) extends zio.aws.mediatailor.model.CreateSourceLocationResponse.ReadOnly {
    override val accessConfiguration
        : Option[zio.aws.mediatailor.model.AccessConfiguration.ReadOnly] = scala
      .Option(impl.accessConfiguration())
      .map(value => zio.aws.mediatailor.model.AccessConfiguration.wrap(value))
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val creationTime: Option[__timestampUnix] =
      scala.Option(impl.creationTime()).map(value => value: __timestampUnix)
    override val defaultSegmentDeliveryConfiguration: Option[
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly
    ] = scala
      .Option(impl.defaultSegmentDeliveryConfiguration())
      .map(value =>
        zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration
          .wrap(value)
      )
    override val httpConfiguration
        : Option[zio.aws.mediatailor.model.HttpConfiguration.ReadOnly] = scala
      .Option(impl.httpConfiguration())
      .map(value => zio.aws.mediatailor.model.HttpConfiguration.wrap(value))
    override val lastModifiedTime: Option[__timestampUnix] =
      scala.Option(impl.lastModifiedTime()).map(value => value: __timestampUnix)
    override val segmentDeliveryConfigurations: Option[
      List[zio.aws.mediatailor.model.SegmentDeliveryConfiguration.ReadOnly]
    ] = scala
      .Option(impl.segmentDeliveryConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediatailor.model.SegmentDeliveryConfiguration.wrap(item)
        }.toList
      )
    override val sourceLocationName: Option[__string] =
      scala.Option(impl.sourceLocationName()).map(value => value: __string)
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateSourceLocationResponse
  ): zio.aws.mediatailor.model.CreateSourceLocationResponse.ReadOnly =
    new Wrapper(impl)
}
