package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateProgramRequest(
    adBreaks: Option[Iterable[zio.aws.mediatailor.model.AdBreak]] = None,
    channelName: __string,
    programName: __string,
    scheduleConfiguration: zio.aws.mediatailor.model.ScheduleConfiguration,
    sourceLocationName: __string,
    vodSourceName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.CreateProgramRequest = {
    import CreateProgramRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.CreateProgramRequest
      .builder()
      .optionallyWith(
        adBreaks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.adBreaks)
      .channelName(channelName: java.lang.String)
      .programName(programName: java.lang.String)
      .scheduleConfiguration(scheduleConfiguration.buildAwsValue())
      .sourceLocationName(sourceLocationName: java.lang.String)
      .vodSourceName(vodSourceName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.CreateProgramRequest.ReadOnly =
    zio.aws.mediatailor.model.CreateProgramRequest.wrap(buildAwsValue())
}
object CreateProgramRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.CreateProgramRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.CreateProgramRequest =
      zio.aws.mediatailor.model.CreateProgramRequest(
        adBreaks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        channelName,
        programName,
        scheduleConfiguration.asEditable,
        sourceLocationName,
        vodSourceName
      )
    def adBreaks: Option[List[zio.aws.mediatailor.model.AdBreak.ReadOnly]]
    def channelName: __string
    def programName: __string
    def scheduleConfiguration
        : zio.aws.mediatailor.model.ScheduleConfiguration.ReadOnly
    def sourceLocationName: __string
    def vodSourceName: __string
    def getAdBreaks
        : ZIO[Any, AwsError, List[zio.aws.mediatailor.model.AdBreak.ReadOnly]] =
      AwsError.unwrapOptionField("adBreaks", adBreaks)
    def getChannelName: ZIO[Any, Nothing, __string] = ZIO.succeed(channelName)
    def getProgramName: ZIO[Any, Nothing, __string] = ZIO.succeed(programName)
    def getScheduleConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.mediatailor.model.ScheduleConfiguration.ReadOnly
    ] = ZIO.succeed(scheduleConfiguration)
    def getSourceLocationName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(sourceLocationName)
    def getVodSourceName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(vodSourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateProgramRequest
  ) extends zio.aws.mediatailor.model.CreateProgramRequest.ReadOnly {
    override val adBreaks
        : Option[List[zio.aws.mediatailor.model.AdBreak.ReadOnly]] = scala
      .Option(impl.adBreaks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediatailor.model.AdBreak.wrap(item)
        }.toList
      )
    override val channelName: __string = impl.channelName(): __string
    override val programName: __string = impl.programName(): __string
    override val scheduleConfiguration
        : zio.aws.mediatailor.model.ScheduleConfiguration.ReadOnly =
      zio.aws.mediatailor.model.ScheduleConfiguration
        .wrap(impl.scheduleConfiguration())
    override val sourceLocationName: __string =
      impl.sourceLocationName(): __string
    override val vodSourceName: __string = impl.vodSourceName(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateProgramRequest
  ): zio.aws.mediatailor.model.CreateProgramRequest.ReadOnly = new Wrapper(impl)
}
