package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateChannelRequest(
    channelName: __string,
    fillerSlate: Option[zio.aws.mediatailor.model.SlateSource] = None,
    outputs: Iterable[zio.aws.mediatailor.model.RequestOutputItem],
    playbackMode: zio.aws.mediatailor.model.PlaybackMode,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.CreateChannelRequest = {
    import CreateChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.CreateChannelRequest
      .builder()
      .channelName(channelName: java.lang.String)
      .optionallyWith(fillerSlate.map(value => value.buildAwsValue()))(
        _.fillerSlate
      )
      .outputs(outputs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .playbackMode(playbackMode.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.CreateChannelRequest.ReadOnly =
    zio.aws.mediatailor.model.CreateChannelRequest.wrap(buildAwsValue())
}
object CreateChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.CreateChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.CreateChannelRequest =
      zio.aws.mediatailor.model.CreateChannelRequest(
        channelName,
        fillerSlate.map(value => value.asEditable),
        outputs.map { item =>
          item.asEditable
        },
        playbackMode,
        tags.map(value => value)
      )
    def channelName: __string
    def fillerSlate: Option[zio.aws.mediatailor.model.SlateSource.ReadOnly]
    def outputs: List[zio.aws.mediatailor.model.RequestOutputItem.ReadOnly]
    def playbackMode: zio.aws.mediatailor.model.PlaybackMode
    def tags: Option[Map[__string, __string]]
    def getChannelName: ZIO[Any, Nothing, __string] = ZIO.succeed(channelName)
    def getFillerSlate
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.SlateSource.ReadOnly] =
      AwsError.unwrapOptionField("fillerSlate", fillerSlate)
    def getOutputs: ZIO[Any, Nothing, List[
      zio.aws.mediatailor.model.RequestOutputItem.ReadOnly
    ]] = ZIO.succeed(outputs)
    def getPlaybackMode
        : ZIO[Any, Nothing, zio.aws.mediatailor.model.PlaybackMode] =
      ZIO.succeed(playbackMode)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateChannelRequest
  ) extends zio.aws.mediatailor.model.CreateChannelRequest.ReadOnly {
    override val channelName: __string = impl.channelName(): __string
    override val fillerSlate
        : Option[zio.aws.mediatailor.model.SlateSource.ReadOnly] = scala
      .Option(impl.fillerSlate())
      .map(value => zio.aws.mediatailor.model.SlateSource.wrap(value))
    override val outputs
        : List[zio.aws.mediatailor.model.RequestOutputItem.ReadOnly] = impl
      .outputs()
      .asScala
      .map { item =>
        zio.aws.mediatailor.model.RequestOutputItem.wrap(item)
      }
      .toList
    override val playbackMode: zio.aws.mediatailor.model.PlaybackMode =
      zio.aws.mediatailor.model.PlaybackMode.wrap(impl.playbackMode())
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateChannelRequest
  ): zio.aws.mediatailor.model.CreateChannelRequest.ReadOnly = new Wrapper(impl)
}
