package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__long
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AdBreak(
    messageType: Option[zio.aws.mediatailor.model.MessageType] = None,
    offsetMillis: Option[__long] = None,
    slate: Option[zio.aws.mediatailor.model.SlateSource] = None,
    spliceInsertMessage: Option[zio.aws.mediatailor.model.SpliceInsertMessage] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.AdBreak = {
    import AdBreak.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.AdBreak
      .builder()
      .optionallyWith(messageType.map(value => value.unwrap))(_.messageType)
      .optionallyWith(offsetMillis.map(value => value: java.lang.Long))(
        _.offsetMillis
      )
      .optionallyWith(slate.map(value => value.buildAwsValue()))(_.slate)
      .optionallyWith(spliceInsertMessage.map(value => value.buildAwsValue()))(
        _.spliceInsertMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.AdBreak.ReadOnly =
    zio.aws.mediatailor.model.AdBreak.wrap(buildAwsValue())
}
object AdBreak {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.AdBreak
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.AdBreak =
      zio.aws.mediatailor.model.AdBreak(
        messageType.map(value => value),
        offsetMillis.map(value => value),
        slate.map(value => value.asEditable),
        spliceInsertMessage.map(value => value.asEditable)
      )
    def messageType: Option[zio.aws.mediatailor.model.MessageType]
    def offsetMillis: Option[__long]
    def slate: Option[zio.aws.mediatailor.model.SlateSource.ReadOnly]
    def spliceInsertMessage
        : Option[zio.aws.mediatailor.model.SpliceInsertMessage.ReadOnly]
    def getMessageType
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.MessageType] =
      AwsError.unwrapOptionField("messageType", messageType)
    def getOffsetMillis: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("offsetMillis", offsetMillis)
    def getSlate
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.SlateSource.ReadOnly] =
      AwsError.unwrapOptionField("slate", slate)
    def getSpliceInsertMessage: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.SpliceInsertMessage.ReadOnly
    ] = AwsError.unwrapOptionField("spliceInsertMessage", spliceInsertMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.AdBreak
  ) extends zio.aws.mediatailor.model.AdBreak.ReadOnly {
    override val messageType: Option[zio.aws.mediatailor.model.MessageType] =
      scala
        .Option(impl.messageType())
        .map(value => zio.aws.mediatailor.model.MessageType.wrap(value))
    override val offsetMillis: Option[__long] =
      scala.Option(impl.offsetMillis()).map(value => value: __long)
    override val slate: Option[zio.aws.mediatailor.model.SlateSource.ReadOnly] =
      scala
        .Option(impl.slate())
        .map(value => zio.aws.mediatailor.model.SlateSource.wrap(value))
    override val spliceInsertMessage
        : Option[zio.aws.mediatailor.model.SpliceInsertMessage.ReadOnly] = scala
      .Option(impl.spliceInsertMessage())
      .map(value => zio.aws.mediatailor.model.SpliceInsertMessage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.AdBreak
  ): zio.aws.mediatailor.model.AdBreak.ReadOnly = new Wrapper(impl)
}
