package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.{__timestampUnix, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class VodSource(
    arn: __string,
    creationTime: Option[__timestampUnix] = None,
    httpPackageConfigurations: Iterable[
      zio.aws.mediatailor.model.HttpPackageConfiguration
    ],
    lastModifiedTime: Option[__timestampUnix] = None,
    sourceLocationName: __string,
    tags: Option[Map[__string, __string]] = None,
    vodSourceName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.VodSource = {
    import VodSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.VodSource
      .builder()
      .arn(__string.unwrap(arn): java.lang.String)
      .optionallyWith(
        creationTime.map(value => __timestampUnix.unwrap(value): Instant)
      )(_.creationTime)
      .httpPackageConfigurations(httpPackageConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        lastModifiedTime.map(value => __timestampUnix.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .sourceLocationName(__string.unwrap(sourceLocationName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .vodSourceName(__string.unwrap(vodSourceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.VodSource.ReadOnly =
    zio.aws.mediatailor.model.VodSource.wrap(buildAwsValue())
}
object VodSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.VodSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.VodSource =
      zio.aws.mediatailor.model.VodSource(
        arn,
        creationTime.map(value => value),
        httpPackageConfigurations.map { item =>
          item.asEditable
        },
        lastModifiedTime.map(value => value),
        sourceLocationName,
        tags.map(value => value),
        vodSourceName
      )
    def arn: __string
    def creationTime: Option[__timestampUnix]
    def httpPackageConfigurations
        : List[zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly]
    def lastModifiedTime: Option[__timestampUnix]
    def sourceLocationName: __string
    def tags: Option[Map[__string, __string]]
    def vodSourceName: __string
    def getArn: ZIO[Any, Nothing, __string] = ZIO.succeed(arn)
    def getCreationTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getHttpPackageConfigurations: ZIO[Any, Nothing, List[
      zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly
    ]] = ZIO.succeed(httpPackageConfigurations)
    def getLastModifiedTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getSourceLocationName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(sourceLocationName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVodSourceName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(vodSourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.VodSource
  ) extends zio.aws.mediatailor.model.VodSource.ReadOnly {
    override val arn: __string =
      zio.aws.mediatailor.model.primitives.__string(impl.arn())
    override val creationTime: Option[__timestampUnix] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.mediatailor.model.primitives.__timestampUnix(value))
    override val httpPackageConfigurations
        : List[zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly] =
      impl
        .httpPackageConfigurations()
        .asScala
        .map { item =>
          zio.aws.mediatailor.model.HttpPackageConfiguration.wrap(item)
        }
        .toList
    override val lastModifiedTime: Option[__timestampUnix] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.mediatailor.model.primitives.__timestampUnix(value))
    override val sourceLocationName: __string =
      zio.aws.mediatailor.model.primitives.__string(impl.sourceLocationName())
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mediatailor.model.primitives.__string(
              key
            ) -> zio.aws.mediatailor.model.primitives.__string(value)
          })
          .toMap
      )
    override val vodSourceName: __string =
      zio.aws.mediatailor.model.primitives.__string(impl.vodSourceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.VodSource
  ): zio.aws.mediatailor.model.VodSource.ReadOnly = new Wrapper(impl)
}
