package zio.aws.mediatailor.model
import scala.jdk.CollectionConverters.*
sealed trait ScheduleEntryType {
  def unwrap
      : software.amazon.awssdk.services.mediatailor.model.ScheduleEntryType
}
object ScheduleEntryType {
  def wrap(
      value: software.amazon.awssdk.services.mediatailor.model.ScheduleEntryType
  ): zio.aws.mediatailor.model.ScheduleEntryType = value match {
    case software.amazon.awssdk.services.mediatailor.model.ScheduleEntryType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediatailor.model.ScheduleEntryType.PROGRAM =>
      val r = PROGRAM
      r
    case software.amazon.awssdk.services.mediatailor.model.ScheduleEntryType.FILLER_SLATE =>
      val r = FILLER_SLATE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediatailor.model.ScheduleEntryType {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.ScheduleEntryType =
      software.amazon.awssdk.services.mediatailor.model.ScheduleEntryType.UNKNOWN_TO_SDK_VERSION
  }
  case object PROGRAM extends zio.aws.mediatailor.model.ScheduleEntryType {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.ScheduleEntryType =
      software.amazon.awssdk.services.mediatailor.model.ScheduleEntryType.PROGRAM
  }
  case object FILLER_SLATE extends zio.aws.mediatailor.model.ScheduleEntryType {
    override def unwrap
        : software.amazon.awssdk.services.mediatailor.model.ScheduleEntryType =
      software.amazon.awssdk.services.mediatailor.model.ScheduleEntryType.FILLER_SLATE
  }
}
