package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.{__string, __timestampUnix, __long}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ScheduleEntry(
    approximateDurationSeconds: Option[__long] = None,
    approximateStartTime: Option[__timestampUnix] = None,
    arn: __string,
    channelName: __string,
    programName: __string,
    scheduleAdBreaks: Option[
      Iterable[zio.aws.mediatailor.model.ScheduleAdBreak]
    ] = None,
    scheduleEntryType: Option[zio.aws.mediatailor.model.ScheduleEntryType] =
      None,
    sourceLocationName: __string,
    vodSourceName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ScheduleEntry = {
    import ScheduleEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ScheduleEntry
      .builder()
      .optionallyWith(
        approximateDurationSeconds.map(value =>
          __long.unwrap(value): java.lang.Long
        )
      )(_.approximateDurationSeconds)
      .optionallyWith(
        approximateStartTime.map(value =>
          __timestampUnix.unwrap(value): Instant
        )
      )(_.approximateStartTime)
      .arn(__string.unwrap(arn): java.lang.String)
      .channelName(__string.unwrap(channelName): java.lang.String)
      .programName(__string.unwrap(programName): java.lang.String)
      .optionallyWith(
        scheduleAdBreaks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scheduleAdBreaks)
      .optionallyWith(scheduleEntryType.map(value => value.unwrap))(
        _.scheduleEntryType
      )
      .sourceLocationName(__string.unwrap(sourceLocationName): java.lang.String)
      .vodSourceName(__string.unwrap(vodSourceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.ScheduleEntry.ReadOnly =
    zio.aws.mediatailor.model.ScheduleEntry.wrap(buildAwsValue())
}
object ScheduleEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ScheduleEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.ScheduleEntry =
      zio.aws.mediatailor.model.ScheduleEntry(
        approximateDurationSeconds.map(value => value),
        approximateStartTime.map(value => value),
        arn,
        channelName,
        programName,
        scheduleAdBreaks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scheduleEntryType.map(value => value),
        sourceLocationName,
        vodSourceName
      )
    def approximateDurationSeconds: Option[__long]
    def approximateStartTime: Option[__timestampUnix]
    def arn: __string
    def channelName: __string
    def programName: __string
    def scheduleAdBreaks
        : Option[List[zio.aws.mediatailor.model.ScheduleAdBreak.ReadOnly]]
    def scheduleEntryType: Option[zio.aws.mediatailor.model.ScheduleEntryType]
    def sourceLocationName: __string
    def vodSourceName: __string
    def getApproximateDurationSeconds: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField(
        "approximateDurationSeconds",
        approximateDurationSeconds
      )
    def getApproximateStartTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("approximateStartTime", approximateStartTime)
    def getArn: ZIO[Any, Nothing, __string] = ZIO.succeed(arn)
    def getChannelName: ZIO[Any, Nothing, __string] = ZIO.succeed(channelName)
    def getProgramName: ZIO[Any, Nothing, __string] = ZIO.succeed(programName)
    def getScheduleAdBreaks: ZIO[Any, AwsError, List[
      zio.aws.mediatailor.model.ScheduleAdBreak.ReadOnly
    ]] = AwsError.unwrapOptionField("scheduleAdBreaks", scheduleAdBreaks)
    def getScheduleEntryType
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.ScheduleEntryType] =
      AwsError.unwrapOptionField("scheduleEntryType", scheduleEntryType)
    def getSourceLocationName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(sourceLocationName)
    def getVodSourceName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(vodSourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ScheduleEntry
  ) extends zio.aws.mediatailor.model.ScheduleEntry.ReadOnly {
    override val approximateDurationSeconds: Option[__long] = scala
      .Option(impl.approximateDurationSeconds())
      .map(value => zio.aws.mediatailor.model.primitives.__long(value))
    override val approximateStartTime: Option[__timestampUnix] = scala
      .Option(impl.approximateStartTime())
      .map(value => zio.aws.mediatailor.model.primitives.__timestampUnix(value))
    override val arn: __string =
      zio.aws.mediatailor.model.primitives.__string(impl.arn())
    override val channelName: __string =
      zio.aws.mediatailor.model.primitives.__string(impl.channelName())
    override val programName: __string =
      zio.aws.mediatailor.model.primitives.__string(impl.programName())
    override val scheduleAdBreaks
        : Option[List[zio.aws.mediatailor.model.ScheduleAdBreak.ReadOnly]] =
      scala
        .Option(impl.scheduleAdBreaks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediatailor.model.ScheduleAdBreak.wrap(item)
          }.toList
        )
    override val scheduleEntryType
        : Option[zio.aws.mediatailor.model.ScheduleEntryType] = scala
      .Option(impl.scheduleEntryType())
      .map(value => zio.aws.mediatailor.model.ScheduleEntryType.wrap(value))
    override val sourceLocationName: __string =
      zio.aws.mediatailor.model.primitives.__string(impl.sourceLocationName())
    override val vodSourceName: __string =
      zio.aws.mediatailor.model.primitives.__string(impl.vodSourceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ScheduleEntry
  ): zio.aws.mediatailor.model.ScheduleEntry.ReadOnly = new Wrapper(impl)
}
