package zio.aws.mediatailor.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ScheduleConfiguration(
    transition: zio.aws.mediatailor.model.Transition
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ScheduleConfiguration = {
    import ScheduleConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ScheduleConfiguration
      .builder()
      .transition(transition.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.ScheduleConfiguration.ReadOnly =
    zio.aws.mediatailor.model.ScheduleConfiguration.wrap(buildAwsValue())
}
object ScheduleConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ScheduleConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.ScheduleConfiguration =
      zio.aws.mediatailor.model.ScheduleConfiguration(transition.asEditable)
    def transition: zio.aws.mediatailor.model.Transition.ReadOnly
    def getTransition
        : ZIO[Any, Nothing, zio.aws.mediatailor.model.Transition.ReadOnly] =
      ZIO.succeed(transition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ScheduleConfiguration
  ) extends zio.aws.mediatailor.model.ScheduleConfiguration.ReadOnly {
    override val transition: zio.aws.mediatailor.model.Transition.ReadOnly =
      zio.aws.mediatailor.model.Transition.wrap(impl.transition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ScheduleConfiguration
  ): zio.aws.mediatailor.model.ScheduleConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
