package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResponseOutputItem(
    dashPlaylistSettings: Option[
      zio.aws.mediatailor.model.DashPlaylistSettings
    ] = None,
    hlsPlaylistSettings: Option[zio.aws.mediatailor.model.HlsPlaylistSettings] =
      None,
    manifestName: __string,
    playbackUrl: __string,
    sourceGroup: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ResponseOutputItem = {
    import ResponseOutputItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ResponseOutputItem
      .builder()
      .optionallyWith(dashPlaylistSettings.map(value => value.buildAwsValue()))(
        _.dashPlaylistSettings
      )
      .optionallyWith(hlsPlaylistSettings.map(value => value.buildAwsValue()))(
        _.hlsPlaylistSettings
      )
      .manifestName(__string.unwrap(manifestName): java.lang.String)
      .playbackUrl(__string.unwrap(playbackUrl): java.lang.String)
      .sourceGroup(__string.unwrap(sourceGroup): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.ResponseOutputItem.ReadOnly =
    zio.aws.mediatailor.model.ResponseOutputItem.wrap(buildAwsValue())
}
object ResponseOutputItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ResponseOutputItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.ResponseOutputItem =
      zio.aws.mediatailor.model.ResponseOutputItem(
        dashPlaylistSettings.map(value => value.asEditable),
        hlsPlaylistSettings.map(value => value.asEditable),
        manifestName,
        playbackUrl,
        sourceGroup
      )
    def dashPlaylistSettings
        : Option[zio.aws.mediatailor.model.DashPlaylistSettings.ReadOnly]
    def hlsPlaylistSettings
        : Option[zio.aws.mediatailor.model.HlsPlaylistSettings.ReadOnly]
    def manifestName: __string
    def playbackUrl: __string
    def sourceGroup: __string
    def getDashPlaylistSettings: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.DashPlaylistSettings.ReadOnly
    ] = AwsError.unwrapOptionField("dashPlaylistSettings", dashPlaylistSettings)
    def getHlsPlaylistSettings: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.HlsPlaylistSettings.ReadOnly
    ] = AwsError.unwrapOptionField("hlsPlaylistSettings", hlsPlaylistSettings)
    def getManifestName: ZIO[Any, Nothing, __string] = ZIO.succeed(manifestName)
    def getPlaybackUrl: ZIO[Any, Nothing, __string] = ZIO.succeed(playbackUrl)
    def getSourceGroup: ZIO[Any, Nothing, __string] = ZIO.succeed(sourceGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ResponseOutputItem
  ) extends zio.aws.mediatailor.model.ResponseOutputItem.ReadOnly {
    override val dashPlaylistSettings
        : Option[zio.aws.mediatailor.model.DashPlaylistSettings.ReadOnly] =
      scala
        .Option(impl.dashPlaylistSettings())
        .map(value =>
          zio.aws.mediatailor.model.DashPlaylistSettings.wrap(value)
        )
    override val hlsPlaylistSettings
        : Option[zio.aws.mediatailor.model.HlsPlaylistSettings.ReadOnly] = scala
      .Option(impl.hlsPlaylistSettings())
      .map(value => zio.aws.mediatailor.model.HlsPlaylistSettings.wrap(value))
    override val manifestName: __string =
      zio.aws.mediatailor.model.primitives.__string(impl.manifestName())
    override val playbackUrl: __string =
      zio.aws.mediatailor.model.primitives.__string(impl.playbackUrl())
    override val sourceGroup: __string =
      zio.aws.mediatailor.model.primitives.__string(impl.sourceGroup())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ResponseOutputItem
  ): zio.aws.mediatailor.model.ResponseOutputItem.ReadOnly = new Wrapper(impl)
}
