package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.{__timestampUnix, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class PrefetchRetrieval(
    dynamicVariables: Option[Map[__string, __string]] = None,
    endTime: __timestampUnix,
    startTime: Option[__timestampUnix] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.PrefetchRetrieval = {
    import PrefetchRetrieval.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.PrefetchRetrieval
      .builder()
      .optionallyWith(
        dynamicVariables.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.dynamicVariables)
      .endTime(__timestampUnix.unwrap(endTime): Instant)
      .optionallyWith(
        startTime.map(value => __timestampUnix.unwrap(value): Instant)
      )(_.startTime)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.PrefetchRetrieval.ReadOnly =
    zio.aws.mediatailor.model.PrefetchRetrieval.wrap(buildAwsValue())
}
object PrefetchRetrieval {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.PrefetchRetrieval
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.PrefetchRetrieval =
      zio.aws.mediatailor.model.PrefetchRetrieval(
        dynamicVariables.map(value => value),
        endTime,
        startTime.map(value => value)
      )
    def dynamicVariables: Option[Map[__string, __string]]
    def endTime: __timestampUnix
    def startTime: Option[__timestampUnix]
    def getDynamicVariables: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("dynamicVariables", dynamicVariables)
    def getEndTime: ZIO[Any, Nothing, __timestampUnix] = ZIO.succeed(endTime)
    def getStartTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("startTime", startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.PrefetchRetrieval
  ) extends zio.aws.mediatailor.model.PrefetchRetrieval.ReadOnly {
    override val dynamicVariables: Option[Map[__string, __string]] = scala
      .Option(impl.dynamicVariables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mediatailor.model.primitives.__string(
              key
            ) -> zio.aws.mediatailor.model.primitives.__string(value)
          })
          .toMap
      )
    override val endTime: __timestampUnix =
      zio.aws.mediatailor.model.primitives.__timestampUnix(impl.endTime())
    override val startTime: Option[__timestampUnix] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.mediatailor.model.primitives.__timestampUnix(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.PrefetchRetrieval
  ): zio.aws.mediatailor.model.PrefetchRetrieval.ReadOnly = new Wrapper(impl)
}
