package zio.aws.mediatailor.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ManifestProcessingRules(
    adMarkerPassthrough: Option[zio.aws.mediatailor.model.AdMarkerPassthrough] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ManifestProcessingRules = {
    import ManifestProcessingRules.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ManifestProcessingRules
      .builder()
      .optionallyWith(adMarkerPassthrough.map(value => value.buildAwsValue()))(
        _.adMarkerPassthrough
      )
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.ManifestProcessingRules.ReadOnly =
    zio.aws.mediatailor.model.ManifestProcessingRules.wrap(buildAwsValue())
}
object ManifestProcessingRules {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ManifestProcessingRules
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.ManifestProcessingRules =
      zio.aws.mediatailor.model.ManifestProcessingRules(
        adMarkerPassthrough.map(value => value.asEditable)
      )
    def adMarkerPassthrough
        : Option[zio.aws.mediatailor.model.AdMarkerPassthrough.ReadOnly]
    def getAdMarkerPassthrough: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.AdMarkerPassthrough.ReadOnly
    ] = AwsError.unwrapOptionField("adMarkerPassthrough", adMarkerPassthrough)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ManifestProcessingRules
  ) extends zio.aws.mediatailor.model.ManifestProcessingRules.ReadOnly {
    override val adMarkerPassthrough
        : Option[zio.aws.mediatailor.model.AdMarkerPassthrough.ReadOnly] = scala
      .Option(impl.adMarkerPassthrough())
      .map(value => zio.aws.mediatailor.model.AdMarkerPassthrough.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ManifestProcessingRules
  ): zio.aws.mediatailor.model.ManifestProcessingRules.ReadOnly = new Wrapper(
    impl
  )
}
