package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListPrefetchSchedulesResponse(
    items: Option[Iterable[zio.aws.mediatailor.model.PrefetchSchedule]] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesResponse = {
    import ListPrefetchSchedulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.ListPrefetchSchedulesResponse.ReadOnly =
    zio.aws.mediatailor.model.ListPrefetchSchedulesResponse
      .wrap(buildAwsValue())
}
object ListPrefetchSchedulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.ListPrefetchSchedulesResponse =
      zio.aws.mediatailor.model.ListPrefetchSchedulesResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Option[List[zio.aws.mediatailor.model.PrefetchSchedule.ReadOnly]]
    def nextToken: Option[__string]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.mediatailor.model.PrefetchSchedule.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesResponse
  ) extends zio.aws.mediatailor.model.ListPrefetchSchedulesResponse.ReadOnly {
    override val items
        : Option[List[zio.aws.mediatailor.model.PrefetchSchedule.ReadOnly]] =
      scala
        .Option(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediatailor.model.PrefetchSchedule.wrap(item)
          }.toList
        )
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesResponse
  ): zio.aws.mediatailor.model.ListPrefetchSchedulesResponse.ReadOnly =
    new Wrapper(impl)
}
