package zio.aws.mediatailor.model
import java.lang.Integer
import zio.aws.mediatailor.model.primitives.{__string, __integerMin1Max100}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListPrefetchSchedulesRequest(
    maxResults: Option[__integerMin1Max100] = None,
    nextToken: Option[__string] = None,
    playbackConfigurationName: __string,
    streamId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest = {
    import ListPrefetchSchedulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => __integerMin1Max100.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .playbackConfigurationName(
        __string.unwrap(playbackConfigurationName): java.lang.String
      )
      .optionallyWith(
        streamId.map(value => __string.unwrap(value): java.lang.String)
      )(_.streamId)
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.ListPrefetchSchedulesRequest.ReadOnly =
    zio.aws.mediatailor.model.ListPrefetchSchedulesRequest.wrap(buildAwsValue())
}
object ListPrefetchSchedulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.ListPrefetchSchedulesRequest =
      zio.aws.mediatailor.model.ListPrefetchSchedulesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        playbackConfigurationName,
        streamId.map(value => value)
      )
    def maxResults: Option[__integerMin1Max100]
    def nextToken: Option[__string]
    def playbackConfigurationName: __string
    def streamId: Option[__string]
    def getMaxResults: ZIO[Any, AwsError, __integerMin1Max100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPlaybackConfigurationName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(playbackConfigurationName)
    def getStreamId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("streamId", streamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest
  ) extends zio.aws.mediatailor.model.ListPrefetchSchedulesRequest.ReadOnly {
    override val maxResults: Option[__integerMin1Max100] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.mediatailor.model.primitives.__integerMin1Max100(value)
      )
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val playbackConfigurationName: __string =
      zio.aws.mediatailor.model.primitives
        .__string(impl.playbackConfigurationName())
    override val streamId: Option[__string] = scala
      .Option(impl.streamId())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest
  ): zio.aws.mediatailor.model.ListPrefetchSchedulesRequest.ReadOnly =
    new Wrapper(impl)
}
