package zio.aws.mediatailor.model
import java.lang.Integer
import zio.aws.mediatailor.model.primitives.{__string, MaxResults}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListChannelsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ListChannelsRequest = {
    import ListChannelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ListChannelsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.ListChannelsRequest.ReadOnly =
    zio.aws.mediatailor.model.ListChannelsRequest.wrap(buildAwsValue())
}
object ListChannelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ListChannelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.ListChannelsRequest =
      zio.aws.mediatailor.model.ListChannelsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ListChannelsRequest
  ) extends zio.aws.mediatailor.model.ListChannelsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.mediatailor.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ListChannelsRequest
  ): zio.aws.mediatailor.model.ListChannelsRequest.ReadOnly = new Wrapper(impl)
}
