package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HlsConfiguration(
    manifestEndpointPrefix: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.HlsConfiguration = {
    import HlsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.HlsConfiguration
      .builder()
      .optionallyWith(
        manifestEndpointPrefix.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.manifestEndpointPrefix)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.HlsConfiguration.ReadOnly =
    zio.aws.mediatailor.model.HlsConfiguration.wrap(buildAwsValue())
}
object HlsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.HlsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.HlsConfiguration =
      zio.aws.mediatailor.model
        .HlsConfiguration(manifestEndpointPrefix.map(value => value))
    def manifestEndpointPrefix: Option[__string]
    def getManifestEndpointPrefix: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("manifestEndpointPrefix", manifestEndpointPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.HlsConfiguration
  ) extends zio.aws.mediatailor.model.HlsConfiguration.ReadOnly {
    override val manifestEndpointPrefix: Option[__string] = scala
      .Option(impl.manifestEndpointPrefix())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.HlsConfiguration
  ): zio.aws.mediatailor.model.HlsConfiguration.ReadOnly = new Wrapper(impl)
}
