package zio.aws.mediatailor.model
import java.lang.Integer
import zio.aws.mediatailor.model.primitives.{__integerMin1, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetPlaybackConfigurationResponse(
    adDecisionServerUrl: Option[__string] = None,
    availSuppression: Option[zio.aws.mediatailor.model.AvailSuppression] = None,
    bumper: Option[zio.aws.mediatailor.model.Bumper] = None,
    cdnConfiguration: Option[zio.aws.mediatailor.model.CdnConfiguration] = None,
    configurationAliases: Option[Map[__string, Map[__string, __string]]] = None,
    dashConfiguration: Option[zio.aws.mediatailor.model.DashConfiguration] =
      None,
    hlsConfiguration: Option[zio.aws.mediatailor.model.HlsConfiguration] = None,
    livePreRollConfiguration: Option[
      zio.aws.mediatailor.model.LivePreRollConfiguration
    ] = None,
    logConfiguration: Option[zio.aws.mediatailor.model.LogConfiguration] = None,
    manifestProcessingRules: Option[
      zio.aws.mediatailor.model.ManifestProcessingRules
    ] = None,
    name: Option[__string] = None,
    personalizationThresholdSeconds: Option[__integerMin1] = None,
    playbackConfigurationArn: Option[__string] = None,
    playbackEndpointPrefix: Option[__string] = None,
    sessionInitializationEndpointPrefix: Option[__string] = None,
    slateAdUrl: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None,
    transcodeProfileName: Option[__string] = None,
    videoContentSourceUrl: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.GetPlaybackConfigurationResponse = {
    import GetPlaybackConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.GetPlaybackConfigurationResponse
      .builder()
      .optionallyWith(
        adDecisionServerUrl.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.adDecisionServerUrl)
      .optionallyWith(availSuppression.map(value => value.buildAwsValue()))(
        _.availSuppression
      )
      .optionallyWith(bumper.map(value => value.buildAwsValue()))(_.bumper)
      .optionallyWith(cdnConfiguration.map(value => value.buildAwsValue()))(
        _.cdnConfiguration
      )
      .optionallyWith(
        configurationAliases.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value
                .map({ case (key, value) =>
                  (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                    value
                  ): java.lang.String)
                })
                .asJava
            })
            .asJava
        )
      )(_.configurationAliases)
      .optionallyWith(dashConfiguration.map(value => value.buildAwsValue()))(
        _.dashConfiguration
      )
      .optionallyWith(hlsConfiguration.map(value => value.buildAwsValue()))(
        _.hlsConfiguration
      )
      .optionallyWith(
        livePreRollConfiguration.map(value => value.buildAwsValue())
      )(_.livePreRollConfiguration)
      .optionallyWith(logConfiguration.map(value => value.buildAwsValue()))(
        _.logConfiguration
      )
      .optionallyWith(
        manifestProcessingRules.map(value => value.buildAwsValue())
      )(_.manifestProcessingRules)
      .optionallyWith(
        name.map(value => __string.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        personalizationThresholdSeconds.map(value =>
          __integerMin1.unwrap(value): Integer
        )
      )(_.personalizationThresholdSeconds)
      .optionallyWith(
        playbackConfigurationArn.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.playbackConfigurationArn)
      .optionallyWith(
        playbackEndpointPrefix.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.playbackEndpointPrefix)
      .optionallyWith(
        sessionInitializationEndpointPrefix.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.sessionInitializationEndpointPrefix)
      .optionallyWith(
        slateAdUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.slateAdUrl)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        transcodeProfileName.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.transcodeProfileName)
      .optionallyWith(
        videoContentSourceUrl.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.videoContentSourceUrl)
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.GetPlaybackConfigurationResponse.ReadOnly =
    zio.aws.mediatailor.model.GetPlaybackConfigurationResponse
      .wrap(buildAwsValue())
}
object GetPlaybackConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.GetPlaybackConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.GetPlaybackConfigurationResponse =
      zio.aws.mediatailor.model.GetPlaybackConfigurationResponse(
        adDecisionServerUrl.map(value => value),
        availSuppression.map(value => value.asEditable),
        bumper.map(value => value.asEditable),
        cdnConfiguration.map(value => value.asEditable),
        configurationAliases.map(value => value),
        dashConfiguration.map(value => value.asEditable),
        hlsConfiguration.map(value => value.asEditable),
        livePreRollConfiguration.map(value => value.asEditable),
        logConfiguration.map(value => value.asEditable),
        manifestProcessingRules.map(value => value.asEditable),
        name.map(value => value),
        personalizationThresholdSeconds.map(value => value),
        playbackConfigurationArn.map(value => value),
        playbackEndpointPrefix.map(value => value),
        sessionInitializationEndpointPrefix.map(value => value),
        slateAdUrl.map(value => value),
        tags.map(value => value),
        transcodeProfileName.map(value => value),
        videoContentSourceUrl.map(value => value)
      )
    def adDecisionServerUrl: Option[__string]
    def availSuppression
        : Option[zio.aws.mediatailor.model.AvailSuppression.ReadOnly]
    def bumper: Option[zio.aws.mediatailor.model.Bumper.ReadOnly]
    def cdnConfiguration
        : Option[zio.aws.mediatailor.model.CdnConfiguration.ReadOnly]
    def configurationAliases: Option[Map[__string, Map[__string, __string]]]
    def dashConfiguration
        : Option[zio.aws.mediatailor.model.DashConfiguration.ReadOnly]
    def hlsConfiguration
        : Option[zio.aws.mediatailor.model.HlsConfiguration.ReadOnly]
    def livePreRollConfiguration
        : Option[zio.aws.mediatailor.model.LivePreRollConfiguration.ReadOnly]
    def logConfiguration
        : Option[zio.aws.mediatailor.model.LogConfiguration.ReadOnly]
    def manifestProcessingRules
        : Option[zio.aws.mediatailor.model.ManifestProcessingRules.ReadOnly]
    def name: Option[__string]
    def personalizationThresholdSeconds: Option[__integerMin1]
    def playbackConfigurationArn: Option[__string]
    def playbackEndpointPrefix: Option[__string]
    def sessionInitializationEndpointPrefix: Option[__string]
    def slateAdUrl: Option[__string]
    def tags: Option[Map[__string, __string]]
    def transcodeProfileName: Option[__string]
    def videoContentSourceUrl: Option[__string]
    def getAdDecisionServerUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("adDecisionServerUrl", adDecisionServerUrl)
    def getAvailSuppression: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.AvailSuppression.ReadOnly
    ] = AwsError.unwrapOptionField("availSuppression", availSuppression)
    def getBumper
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.Bumper.ReadOnly] =
      AwsError.unwrapOptionField("bumper", bumper)
    def getCdnConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.CdnConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("cdnConfiguration", cdnConfiguration)
    def getConfigurationAliases
        : ZIO[Any, AwsError, Map[__string, Map[__string, __string]]] =
      AwsError.unwrapOptionField("configurationAliases", configurationAliases)
    def getDashConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.DashConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("dashConfiguration", dashConfiguration)
    def getHlsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.HlsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("hlsConfiguration", hlsConfiguration)
    def getLivePreRollConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.LivePreRollConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "livePreRollConfiguration",
      livePreRollConfiguration
    )
    def getLogConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.LogConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("logConfiguration", logConfiguration)
    def getManifestProcessingRules: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.ManifestProcessingRules.ReadOnly
    ] = AwsError.unwrapOptionField(
      "manifestProcessingRules",
      manifestProcessingRules
    )
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getPersonalizationThresholdSeconds: ZIO[Any, AwsError, __integerMin1] =
      AwsError.unwrapOptionField(
        "personalizationThresholdSeconds",
        personalizationThresholdSeconds
      )
    def getPlaybackConfigurationArn: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("playbackConfigurationArn", playbackConfigurationArn)
    def getPlaybackEndpointPrefix: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("playbackEndpointPrefix", playbackEndpointPrefix)
    def getSessionInitializationEndpointPrefix: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "sessionInitializationEndpointPrefix",
        sessionInitializationEndpointPrefix
      )
    def getSlateAdUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("slateAdUrl", slateAdUrl)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTranscodeProfileName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("transcodeProfileName", transcodeProfileName)
    def getVideoContentSourceUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("videoContentSourceUrl", videoContentSourceUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.GetPlaybackConfigurationResponse
  ) extends zio.aws.mediatailor.model.GetPlaybackConfigurationResponse.ReadOnly {
    override val adDecisionServerUrl: Option[__string] = scala
      .Option(impl.adDecisionServerUrl())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val availSuppression
        : Option[zio.aws.mediatailor.model.AvailSuppression.ReadOnly] = scala
      .Option(impl.availSuppression())
      .map(value => zio.aws.mediatailor.model.AvailSuppression.wrap(value))
    override val bumper: Option[zio.aws.mediatailor.model.Bumper.ReadOnly] =
      scala
        .Option(impl.bumper())
        .map(value => zio.aws.mediatailor.model.Bumper.wrap(value))
    override val cdnConfiguration
        : Option[zio.aws.mediatailor.model.CdnConfiguration.ReadOnly] = scala
      .Option(impl.cdnConfiguration())
      .map(value => zio.aws.mediatailor.model.CdnConfiguration.wrap(value))
    override val configurationAliases
        : Option[Map[__string, Map[__string, __string]]] = scala
      .Option(impl.configurationAliases())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mediatailor.model.primitives.__string(key) -> value.asScala
              .map({ case (key, value) =>
                zio.aws.mediatailor.model.primitives.__string(
                  key
                ) -> zio.aws.mediatailor.model.primitives.__string(value)
              })
              .toMap
          })
          .toMap
      )
    override val dashConfiguration
        : Option[zio.aws.mediatailor.model.DashConfiguration.ReadOnly] = scala
      .Option(impl.dashConfiguration())
      .map(value => zio.aws.mediatailor.model.DashConfiguration.wrap(value))
    override val hlsConfiguration
        : Option[zio.aws.mediatailor.model.HlsConfiguration.ReadOnly] = scala
      .Option(impl.hlsConfiguration())
      .map(value => zio.aws.mediatailor.model.HlsConfiguration.wrap(value))
    override val livePreRollConfiguration
        : Option[zio.aws.mediatailor.model.LivePreRollConfiguration.ReadOnly] =
      scala
        .Option(impl.livePreRollConfiguration())
        .map(value =>
          zio.aws.mediatailor.model.LivePreRollConfiguration.wrap(value)
        )
    override val logConfiguration
        : Option[zio.aws.mediatailor.model.LogConfiguration.ReadOnly] = scala
      .Option(impl.logConfiguration())
      .map(value => zio.aws.mediatailor.model.LogConfiguration.wrap(value))
    override val manifestProcessingRules
        : Option[zio.aws.mediatailor.model.ManifestProcessingRules.ReadOnly] =
      scala
        .Option(impl.manifestProcessingRules())
        .map(value =>
          zio.aws.mediatailor.model.ManifestProcessingRules.wrap(value)
        )
    override val name: Option[__string] = scala
      .Option(impl.name())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val personalizationThresholdSeconds: Option[__integerMin1] = scala
      .Option(impl.personalizationThresholdSeconds())
      .map(value => zio.aws.mediatailor.model.primitives.__integerMin1(value))
    override val playbackConfigurationArn: Option[__string] = scala
      .Option(impl.playbackConfigurationArn())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val playbackEndpointPrefix: Option[__string] = scala
      .Option(impl.playbackEndpointPrefix())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val sessionInitializationEndpointPrefix: Option[__string] = scala
      .Option(impl.sessionInitializationEndpointPrefix())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val slateAdUrl: Option[__string] = scala
      .Option(impl.slateAdUrl())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mediatailor.model.primitives.__string(
              key
            ) -> zio.aws.mediatailor.model.primitives.__string(value)
          })
          .toMap
      )
    override val transcodeProfileName: Option[__string] = scala
      .Option(impl.transcodeProfileName())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val videoContentSourceUrl: Option[__string] = scala
      .Option(impl.videoContentSourceUrl())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.GetPlaybackConfigurationResponse
  ): zio.aws.mediatailor.model.GetPlaybackConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
