package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DashConfiguration(
    manifestEndpointPrefix: Option[__string] = None,
    mpdLocation: Option[__string] = None,
    originManifestType: Option[zio.aws.mediatailor.model.OriginManifestType] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.DashConfiguration = {
    import DashConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.DashConfiguration
      .builder()
      .optionallyWith(
        manifestEndpointPrefix.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.manifestEndpointPrefix)
      .optionallyWith(
        mpdLocation.map(value => __string.unwrap(value): java.lang.String)
      )(_.mpdLocation)
      .optionallyWith(originManifestType.map(value => value.unwrap))(
        _.originManifestType
      )
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.DashConfiguration.ReadOnly =
    zio.aws.mediatailor.model.DashConfiguration.wrap(buildAwsValue())
}
object DashConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.DashConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.DashConfiguration =
      zio.aws.mediatailor.model.DashConfiguration(
        manifestEndpointPrefix.map(value => value),
        mpdLocation.map(value => value),
        originManifestType.map(value => value)
      )
    def manifestEndpointPrefix: Option[__string]
    def mpdLocation: Option[__string]
    def originManifestType: Option[zio.aws.mediatailor.model.OriginManifestType]
    def getManifestEndpointPrefix: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("manifestEndpointPrefix", manifestEndpointPrefix)
    def getMpdLocation: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("mpdLocation", mpdLocation)
    def getOriginManifestType
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.OriginManifestType] =
      AwsError.unwrapOptionField("originManifestType", originManifestType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.DashConfiguration
  ) extends zio.aws.mediatailor.model.DashConfiguration.ReadOnly {
    override val manifestEndpointPrefix: Option[__string] = scala
      .Option(impl.manifestEndpointPrefix())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val mpdLocation: Option[__string] = scala
      .Option(impl.mpdLocation())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val originManifestType
        : Option[zio.aws.mediatailor.model.OriginManifestType] = scala
      .Option(impl.originManifestType())
      .map(value => zio.aws.mediatailor.model.OriginManifestType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.DashConfiguration
  ): zio.aws.mediatailor.model.DashConfiguration.ReadOnly = new Wrapper(impl)
}
