package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateSourceLocationRequest(
    accessConfiguration: Option[zio.aws.mediatailor.model.AccessConfiguration] =
      None,
    defaultSegmentDeliveryConfiguration: Option[
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration
    ] = None,
    httpConfiguration: zio.aws.mediatailor.model.HttpConfiguration,
    segmentDeliveryConfigurations: Option[
      Iterable[zio.aws.mediatailor.model.SegmentDeliveryConfiguration]
    ] = None,
    sourceLocationName: __string,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.CreateSourceLocationRequest = {
    import CreateSourceLocationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.CreateSourceLocationRequest
      .builder()
      .optionallyWith(accessConfiguration.map(value => value.buildAwsValue()))(
        _.accessConfiguration
      )
      .optionallyWith(
        defaultSegmentDeliveryConfiguration.map(value => value.buildAwsValue())
      )(_.defaultSegmentDeliveryConfiguration)
      .httpConfiguration(httpConfiguration.buildAwsValue())
      .optionallyWith(
        segmentDeliveryConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.segmentDeliveryConfigurations)
      .sourceLocationName(__string.unwrap(sourceLocationName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.CreateSourceLocationRequest.ReadOnly =
    zio.aws.mediatailor.model.CreateSourceLocationRequest.wrap(buildAwsValue())
}
object CreateSourceLocationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.CreateSourceLocationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.CreateSourceLocationRequest =
      zio.aws.mediatailor.model.CreateSourceLocationRequest(
        accessConfiguration.map(value => value.asEditable),
        defaultSegmentDeliveryConfiguration.map(value => value.asEditable),
        httpConfiguration.asEditable,
        segmentDeliveryConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceLocationName,
        tags.map(value => value)
      )
    def accessConfiguration
        : Option[zio.aws.mediatailor.model.AccessConfiguration.ReadOnly]
    def defaultSegmentDeliveryConfiguration: Option[
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly
    ]
    def httpConfiguration: zio.aws.mediatailor.model.HttpConfiguration.ReadOnly
    def segmentDeliveryConfigurations: Option[
      List[zio.aws.mediatailor.model.SegmentDeliveryConfiguration.ReadOnly]
    ]
    def sourceLocationName: __string
    def tags: Option[Map[__string, __string]]
    def getAccessConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.AccessConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("accessConfiguration", accessConfiguration)
    def getDefaultSegmentDeliveryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultSegmentDeliveryConfiguration",
      defaultSegmentDeliveryConfiguration
    )
    def getHttpConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.mediatailor.model.HttpConfiguration.ReadOnly
    ] = ZIO.succeed(httpConfiguration)
    def getSegmentDeliveryConfigurations: ZIO[Any, AwsError, List[
      zio.aws.mediatailor.model.SegmentDeliveryConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "segmentDeliveryConfigurations",
      segmentDeliveryConfigurations
    )
    def getSourceLocationName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(sourceLocationName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateSourceLocationRequest
  ) extends zio.aws.mediatailor.model.CreateSourceLocationRequest.ReadOnly {
    override val accessConfiguration
        : Option[zio.aws.mediatailor.model.AccessConfiguration.ReadOnly] = scala
      .Option(impl.accessConfiguration())
      .map(value => zio.aws.mediatailor.model.AccessConfiguration.wrap(value))
    override val defaultSegmentDeliveryConfiguration: Option[
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly
    ] = scala
      .Option(impl.defaultSegmentDeliveryConfiguration())
      .map(value =>
        zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration
          .wrap(value)
      )
    override val httpConfiguration
        : zio.aws.mediatailor.model.HttpConfiguration.ReadOnly =
      zio.aws.mediatailor.model.HttpConfiguration.wrap(impl.httpConfiguration())
    override val segmentDeliveryConfigurations: Option[
      List[zio.aws.mediatailor.model.SegmentDeliveryConfiguration.ReadOnly]
    ] = scala
      .Option(impl.segmentDeliveryConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediatailor.model.SegmentDeliveryConfiguration.wrap(item)
        }.toList
      )
    override val sourceLocationName: __string =
      zio.aws.mediatailor.model.primitives.__string(impl.sourceLocationName())
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mediatailor.model.primitives.__string(
              key
            ) -> zio.aws.mediatailor.model.primitives.__string(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateSourceLocationRequest
  ): zio.aws.mediatailor.model.CreateSourceLocationRequest.ReadOnly =
    new Wrapper(impl)
}
