package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.{__timestampUnix, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CreateProgramResponse(
    adBreaks: Option[Iterable[zio.aws.mediatailor.model.AdBreak]] = None,
    arn: Option[__string] = None,
    channelName: Option[__string] = None,
    creationTime: Option[__timestampUnix] = None,
    programName: Option[__string] = None,
    scheduledStartTime: Option[__timestampUnix] = None,
    sourceLocationName: Option[__string] = None,
    vodSourceName: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.CreateProgramResponse = {
    import CreateProgramResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.CreateProgramResponse
      .builder()
      .optionallyWith(
        adBreaks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.adBreaks)
      .optionallyWith(
        arn.map(value => __string.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        channelName.map(value => __string.unwrap(value): java.lang.String)
      )(_.channelName)
      .optionallyWith(
        creationTime.map(value => __timestampUnix.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        programName.map(value => __string.unwrap(value): java.lang.String)
      )(_.programName)
      .optionallyWith(
        scheduledStartTime.map(value => __timestampUnix.unwrap(value): Instant)
      )(_.scheduledStartTime)
      .optionallyWith(
        sourceLocationName.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.sourceLocationName)
      .optionallyWith(
        vodSourceName.map(value => __string.unwrap(value): java.lang.String)
      )(_.vodSourceName)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.CreateProgramResponse.ReadOnly =
    zio.aws.mediatailor.model.CreateProgramResponse.wrap(buildAwsValue())
}
object CreateProgramResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.CreateProgramResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.CreateProgramResponse =
      zio.aws.mediatailor.model.CreateProgramResponse(
        adBreaks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        arn.map(value => value),
        channelName.map(value => value),
        creationTime.map(value => value),
        programName.map(value => value),
        scheduledStartTime.map(value => value),
        sourceLocationName.map(value => value),
        vodSourceName.map(value => value)
      )
    def adBreaks: Option[List[zio.aws.mediatailor.model.AdBreak.ReadOnly]]
    def arn: Option[__string]
    def channelName: Option[__string]
    def creationTime: Option[__timestampUnix]
    def programName: Option[__string]
    def scheduledStartTime: Option[__timestampUnix]
    def sourceLocationName: Option[__string]
    def vodSourceName: Option[__string]
    def getAdBreaks
        : ZIO[Any, AwsError, List[zio.aws.mediatailor.model.AdBreak.ReadOnly]] =
      AwsError.unwrapOptionField("adBreaks", adBreaks)
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getChannelName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("channelName", channelName)
    def getCreationTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getProgramName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("programName", programName)
    def getScheduledStartTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("scheduledStartTime", scheduledStartTime)
    def getSourceLocationName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceLocationName", sourceLocationName)
    def getVodSourceName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("vodSourceName", vodSourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateProgramResponse
  ) extends zio.aws.mediatailor.model.CreateProgramResponse.ReadOnly {
    override val adBreaks
        : Option[List[zio.aws.mediatailor.model.AdBreak.ReadOnly]] = scala
      .Option(impl.adBreaks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediatailor.model.AdBreak.wrap(item)
        }.toList
      )
    override val arn: Option[__string] = scala
      .Option(impl.arn())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val channelName: Option[__string] = scala
      .Option(impl.channelName())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val creationTime: Option[__timestampUnix] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.mediatailor.model.primitives.__timestampUnix(value))
    override val programName: Option[__string] = scala
      .Option(impl.programName())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val scheduledStartTime: Option[__timestampUnix] = scala
      .Option(impl.scheduledStartTime())
      .map(value => zio.aws.mediatailor.model.primitives.__timestampUnix(value))
    override val sourceLocationName: Option[__string] = scala
      .Option(impl.sourceLocationName())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val vodSourceName: Option[__string] = scala
      .Option(impl.vodSourceName())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.CreateProgramResponse
  ): zio.aws.mediatailor.model.CreateProgramResponse.ReadOnly = new Wrapper(
    impl
  )
}
