package zio.aws.mediatailor
import zio.aws.mediatailor.model.GetPrefetchScheduleResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.mediatailor.model.{
  PutPlaybackConfigurationRequest,
  CreateProgramRequest,
  StartChannelRequest,
  CreateVodSourceRequest,
  DeleteChannelPolicyRequest,
  CreateSourceLocationRequest,
  CreatePrefetchScheduleRequest,
  DeleteChannelRequest,
  DeleteSourceLocationRequest,
  CreateChannelRequest,
  DeleteVodSourceRequest,
  ListTagsForResourceRequest,
  ListVodSourcesRequest,
  DescribeSourceLocationRequest,
  GetChannelScheduleRequest,
  GetPlaybackConfigurationRequest,
  ListPrefetchSchedulesRequest,
  UpdateChannelRequest,
  ListPlaybackConfigurationsRequest,
  GetChannelPolicyRequest,
  UpdateSourceLocationRequest,
  ListAlertsRequest,
  ListChannelsRequest,
  UntagResourceRequest,
  UpdateVodSourceRequest,
  DeleteProgramRequest,
  DeletePrefetchScheduleRequest,
  StopChannelRequest,
  GetPrefetchScheduleRequest,
  DeletePlaybackConfigurationRequest,
  DescribeProgramRequest,
  DescribeChannelRequest,
  ListSourceLocationsRequest,
  PutChannelPolicyRequest,
  DescribeVodSourceRequest,
  TagResourceRequest,
  ConfigureLogsForPlaybackConfigurationRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.mediatailor.MediaTailorAsyncClient
object MediaTailorMock extends Mock[MediaTailor] {
  object PutChannelPolicy
      extends Effect[
        PutChannelPolicyRequest,
        AwsError,
        zio.aws.mediatailor.model.PutChannelPolicyResponse.ReadOnly
      ]
  object CreateSourceLocation
      extends Effect[
        CreateSourceLocationRequest,
        AwsError,
        zio.aws.mediatailor.model.CreateSourceLocationResponse.ReadOnly
      ]
  object GetChannelSchedule
      extends Stream[
        GetChannelScheduleRequest,
        AwsError,
        zio.aws.mediatailor.model.ScheduleEntry.ReadOnly
      ]
  object GetChannelSchedulePaginated
      extends Effect[
        GetChannelScheduleRequest,
        AwsError,
        zio.aws.mediatailor.model.GetChannelScheduleResponse.ReadOnly
      ]
  object CreateVodSource
      extends Effect[
        CreateVodSourceRequest,
        AwsError,
        zio.aws.mediatailor.model.CreateVodSourceResponse.ReadOnly
      ]
  object ListChannels
      extends Stream[
        ListChannelsRequest,
        AwsError,
        zio.aws.mediatailor.model.Channel.ReadOnly
      ]
  object ListChannelsPaginated
      extends Effect[
        ListChannelsRequest,
        AwsError,
        zio.aws.mediatailor.model.ListChannelsResponse.ReadOnly
      ]
  object GetChannelPolicy
      extends Effect[
        GetChannelPolicyRequest,
        AwsError,
        zio.aws.mediatailor.model.GetChannelPolicyResponse.ReadOnly
      ]
  object CreateProgram
      extends Effect[
        CreateProgramRequest,
        AwsError,
        zio.aws.mediatailor.model.CreateProgramResponse.ReadOnly
      ]
  object DescribeProgram
      extends Effect[
        DescribeProgramRequest,
        AwsError,
        zio.aws.mediatailor.model.DescribeProgramResponse.ReadOnly
      ]
  object ListSourceLocations
      extends Stream[
        ListSourceLocationsRequest,
        AwsError,
        zio.aws.mediatailor.model.SourceLocation.ReadOnly
      ]
  object ListSourceLocationsPaginated
      extends Effect[
        ListSourceLocationsRequest,
        AwsError,
        zio.aws.mediatailor.model.ListSourceLocationsResponse.ReadOnly
      ]
  object CreatePrefetchSchedule
      extends Effect[
        CreatePrefetchScheduleRequest,
        AwsError,
        zio.aws.mediatailor.model.CreatePrefetchScheduleResponse.ReadOnly
      ]
  object DeleteChannel
      extends Effect[
        DeleteChannelRequest,
        AwsError,
        zio.aws.mediatailor.model.DeleteChannelResponse.ReadOnly
      ]
  object ConfigureLogsForPlaybackConfiguration
      extends Effect[
        ConfigureLogsForPlaybackConfigurationRequest,
        AwsError,
        zio.aws.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse.ReadOnly
      ]
  object GetPrefetchSchedule
      extends Effect[GetPrefetchScheduleRequest, AwsError, ReadOnly]
  object GetPlaybackConfiguration
      extends Effect[
        GetPlaybackConfigurationRequest,
        AwsError,
        zio.aws.mediatailor.model.GetPlaybackConfigurationResponse.ReadOnly
      ]
  object UpdateVodSource
      extends Effect[
        UpdateVodSourceRequest,
        AwsError,
        zio.aws.mediatailor.model.UpdateVodSourceResponse.ReadOnly
      ]
  object StartChannel
      extends Effect[
        StartChannelRequest,
        AwsError,
        zio.aws.mediatailor.model.StartChannelResponse.ReadOnly
      ]
  object DeleteSourceLocation
      extends Effect[
        DeleteSourceLocationRequest,
        AwsError,
        zio.aws.mediatailor.model.DeleteSourceLocationResponse.ReadOnly
      ]
  object CreateChannel
      extends Effect[
        CreateChannelRequest,
        AwsError,
        zio.aws.mediatailor.model.CreateChannelResponse.ReadOnly
      ]
  object DeletePrefetchSchedule
      extends Effect[
        DeletePrefetchScheduleRequest,
        AwsError,
        zio.aws.mediatailor.model.DeletePrefetchScheduleResponse.ReadOnly
      ]
  object DeletePlaybackConfiguration
      extends Effect[
        DeletePlaybackConfigurationRequest,
        AwsError,
        zio.aws.mediatailor.model.DeletePlaybackConfigurationResponse.ReadOnly
      ]
  object UpdateSourceLocation
      extends Effect[
        UpdateSourceLocationRequest,
        AwsError,
        zio.aws.mediatailor.model.UpdateSourceLocationResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object StopChannel
      extends Effect[
        StopChannelRequest,
        AwsError,
        zio.aws.mediatailor.model.StopChannelResponse.ReadOnly
      ]
  object DeleteVodSource
      extends Effect[
        DeleteVodSourceRequest,
        AwsError,
        zio.aws.mediatailor.model.DeleteVodSourceResponse.ReadOnly
      ]
  object DeleteProgram
      extends Effect[
        DeleteProgramRequest,
        AwsError,
        zio.aws.mediatailor.model.DeleteProgramResponse.ReadOnly
      ]
  object ListAlerts
      extends Stream[
        ListAlertsRequest,
        AwsError,
        zio.aws.mediatailor.model.Alert.ReadOnly
      ]
  object ListAlertsPaginated
      extends Effect[
        ListAlertsRequest,
        AwsError,
        zio.aws.mediatailor.model.ListAlertsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.mediatailor.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object DescribeChannel
      extends Effect[
        DescribeChannelRequest,
        AwsError,
        zio.aws.mediatailor.model.DescribeChannelResponse.ReadOnly
      ]
  object ListPrefetchSchedules
      extends Stream[
        ListPrefetchSchedulesRequest,
        AwsError,
        zio.aws.mediatailor.model.PrefetchSchedule.ReadOnly
      ]
  object ListPrefetchSchedulesPaginated
      extends Effect[
        ListPrefetchSchedulesRequest,
        AwsError,
        zio.aws.mediatailor.model.ListPrefetchSchedulesResponse.ReadOnly
      ]
  object PutPlaybackConfiguration
      extends Effect[
        PutPlaybackConfigurationRequest,
        AwsError,
        zio.aws.mediatailor.model.PutPlaybackConfigurationResponse.ReadOnly
      ]
  object DescribeSourceLocation
      extends Effect[
        DescribeSourceLocationRequest,
        AwsError,
        zio.aws.mediatailor.model.DescribeSourceLocationResponse.ReadOnly
      ]
  object ListVodSources
      extends Stream[
        ListVodSourcesRequest,
        AwsError,
        zio.aws.mediatailor.model.VodSource.ReadOnly
      ]
  object ListVodSourcesPaginated
      extends Effect[
        ListVodSourcesRequest,
        AwsError,
        zio.aws.mediatailor.model.ListVodSourcesResponse.ReadOnly
      ]
  object DescribeVodSource
      extends Effect[
        DescribeVodSourceRequest,
        AwsError,
        zio.aws.mediatailor.model.DescribeVodSourceResponse.ReadOnly
      ]
  object ListPlaybackConfigurations
      extends Stream[
        ListPlaybackConfigurationsRequest,
        AwsError,
        zio.aws.mediatailor.model.PlaybackConfiguration.ReadOnly
      ]
  object ListPlaybackConfigurationsPaginated
      extends Effect[
        ListPlaybackConfigurationsRequest,
        AwsError,
        zio.aws.mediatailor.model.ListPlaybackConfigurationsResponse.ReadOnly
      ]
  object UpdateChannel
      extends Effect[
        UpdateChannelRequest,
        AwsError,
        zio.aws.mediatailor.model.UpdateChannelResponse.ReadOnly
      ]
  object DeleteChannelPolicy
      extends Effect[
        DeleteChannelPolicyRequest,
        AwsError,
        zio.aws.mediatailor.model.DeleteChannelPolicyResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, MediaTailor] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new MediaTailor {
          val api: MediaTailorAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : MediaTailor = this
          def putChannelPolicy(request: PutChannelPolicyRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.PutChannelPolicyResponse.ReadOnly
          ] = proxy(PutChannelPolicy, request)
          def createSourceLocation(request: CreateSourceLocationRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.CreateSourceLocationResponse.ReadOnly
          ] = proxy(CreateSourceLocation, request)
          def getChannelSchedule(request: GetChannelScheduleRequest): ZStream[
            Any,
            AwsError,
            zio.aws.mediatailor.model.ScheduleEntry.ReadOnly
          ] = rts.unsafeRun(proxy(GetChannelSchedule, request))
          def getChannelSchedulePaginated(
              request: GetChannelScheduleRequest
          ): IO[
            AwsError,
            zio.aws.mediatailor.model.GetChannelScheduleResponse.ReadOnly
          ] = proxy(GetChannelSchedulePaginated, request)
          def createVodSource(request: CreateVodSourceRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.CreateVodSourceResponse.ReadOnly
          ] = proxy(CreateVodSource, request)
          def listChannels(request: ListChannelsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.mediatailor.model.Channel.ReadOnly
          ] = rts.unsafeRun(proxy(ListChannels, request))
          def listChannelsPaginated(request: ListChannelsRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.ListChannelsResponse.ReadOnly
          ] = proxy(ListChannelsPaginated, request)
          def getChannelPolicy(request: GetChannelPolicyRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.GetChannelPolicyResponse.ReadOnly
          ] = proxy(GetChannelPolicy, request)
          def createProgram(request: CreateProgramRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.CreateProgramResponse.ReadOnly
          ] = proxy(CreateProgram, request)
          def describeProgram(request: DescribeProgramRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.DescribeProgramResponse.ReadOnly
          ] = proxy(DescribeProgram, request)
          def listSourceLocations(request: ListSourceLocationsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.mediatailor.model.SourceLocation.ReadOnly
          ] = rts.unsafeRun(proxy(ListSourceLocations, request))
          def listSourceLocationsPaginated(
              request: ListSourceLocationsRequest
          ): IO[
            AwsError,
            zio.aws.mediatailor.model.ListSourceLocationsResponse.ReadOnly
          ] = proxy(ListSourceLocationsPaginated, request)
          def createPrefetchSchedule(
              request: CreatePrefetchScheduleRequest
          ): IO[
            AwsError,
            zio.aws.mediatailor.model.CreatePrefetchScheduleResponse.ReadOnly
          ] = proxy(CreatePrefetchSchedule, request)
          def deleteChannel(request: DeleteChannelRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.DeleteChannelResponse.ReadOnly
          ] = proxy(DeleteChannel, request)
          def configureLogsForPlaybackConfiguration(
              request: ConfigureLogsForPlaybackConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.mediatailor.model.ConfigureLogsForPlaybackConfigurationResponse.ReadOnly
          ] = proxy(ConfigureLogsForPlaybackConfiguration, request)
          def getPrefetchSchedule(
              request: GetPrefetchScheduleRequest
          ): IO[AwsError, ReadOnly] = proxy(GetPrefetchSchedule, request)
          def getPlaybackConfiguration(
              request: GetPlaybackConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.mediatailor.model.GetPlaybackConfigurationResponse.ReadOnly
          ] = proxy(GetPlaybackConfiguration, request)
          def updateVodSource(request: UpdateVodSourceRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.UpdateVodSourceResponse.ReadOnly
          ] = proxy(UpdateVodSource, request)
          def startChannel(request: StartChannelRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.StartChannelResponse.ReadOnly
          ] = proxy(StartChannel, request)
          def deleteSourceLocation(request: DeleteSourceLocationRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.DeleteSourceLocationResponse.ReadOnly
          ] = proxy(DeleteSourceLocation, request)
          def createChannel(request: CreateChannelRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.CreateChannelResponse.ReadOnly
          ] = proxy(CreateChannel, request)
          def deletePrefetchSchedule(
              request: DeletePrefetchScheduleRequest
          ): IO[
            AwsError,
            zio.aws.mediatailor.model.DeletePrefetchScheduleResponse.ReadOnly
          ] = proxy(DeletePrefetchSchedule, request)
          def deletePlaybackConfiguration(
              request: DeletePlaybackConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.mediatailor.model.DeletePlaybackConfigurationResponse.ReadOnly
          ] = proxy(DeletePlaybackConfiguration, request)
          def updateSourceLocation(request: UpdateSourceLocationRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.UpdateSourceLocationResponse.ReadOnly
          ] = proxy(UpdateSourceLocation, request)
          def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
            proxy(UntagResource, request)
          def stopChannel(request: StopChannelRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.StopChannelResponse.ReadOnly
          ] = proxy(StopChannel, request)
          def deleteVodSource(request: DeleteVodSourceRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.DeleteVodSourceResponse.ReadOnly
          ] = proxy(DeleteVodSource, request)
          def deleteProgram(request: DeleteProgramRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.DeleteProgramResponse.ReadOnly
          ] = proxy(DeleteProgram, request)
          def listAlerts(
              request: ListAlertsRequest
          ): ZStream[Any, AwsError, zio.aws.mediatailor.model.Alert.ReadOnly] =
            rts.unsafeRun(proxy(ListAlerts, request))
          def listAlertsPaginated(request: ListAlertsRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.ListAlertsResponse.ReadOnly
          ] = proxy(ListAlertsPaginated, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
            proxy(TagResource, request)
          def describeChannel(request: DescribeChannelRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.DescribeChannelResponse.ReadOnly
          ] = proxy(DescribeChannel, request)
          def listPrefetchSchedules(
              request: ListPrefetchSchedulesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.mediatailor.model.PrefetchSchedule.ReadOnly
          ] = rts.unsafeRun(proxy(ListPrefetchSchedules, request))
          def listPrefetchSchedulesPaginated(
              request: ListPrefetchSchedulesRequest
          ): IO[
            AwsError,
            zio.aws.mediatailor.model.ListPrefetchSchedulesResponse.ReadOnly
          ] = proxy(ListPrefetchSchedulesPaginated, request)
          def putPlaybackConfiguration(
              request: PutPlaybackConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.mediatailor.model.PutPlaybackConfigurationResponse.ReadOnly
          ] = proxy(PutPlaybackConfiguration, request)
          def describeSourceLocation(
              request: DescribeSourceLocationRequest
          ): IO[
            AwsError,
            zio.aws.mediatailor.model.DescribeSourceLocationResponse.ReadOnly
          ] = proxy(DescribeSourceLocation, request)
          def listVodSources(request: ListVodSourcesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.mediatailor.model.VodSource.ReadOnly
          ] = rts.unsafeRun(proxy(ListVodSources, request))
          def listVodSourcesPaginated(request: ListVodSourcesRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.ListVodSourcesResponse.ReadOnly
          ] = proxy(ListVodSourcesPaginated, request)
          def describeVodSource(request: DescribeVodSourceRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.DescribeVodSourceResponse.ReadOnly
          ] = proxy(DescribeVodSource, request)
          def listPlaybackConfigurations(
              request: ListPlaybackConfigurationsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.mediatailor.model.PlaybackConfiguration.ReadOnly
          ] = rts.unsafeRun(proxy(ListPlaybackConfigurations, request))
          def listPlaybackConfigurationsPaginated(
              request: ListPlaybackConfigurationsRequest
          ): IO[
            AwsError,
            zio.aws.mediatailor.model.ListPlaybackConfigurationsResponse.ReadOnly
          ] = proxy(ListPlaybackConfigurationsPaginated, request)
          def updateChannel(request: UpdateChannelRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.UpdateChannelResponse.ReadOnly
          ] = proxy(UpdateChannel, request)
          def deleteChannelPolicy(request: DeleteChannelPolicyRequest): IO[
            AwsError,
            zio.aws.mediatailor.model.DeleteChannelPolicyResponse.ReadOnly
          ] = proxy(DeleteChannelPolicy, request)
        }
      }
    }
    .toLayer
}
