package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateVodSourceRequest(
    httpPackageConfigurations: Iterable[
      zio.aws.mediatailor.model.HttpPackageConfiguration
    ],
    sourceLocationName: __string,
    vodSourceName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.UpdateVodSourceRequest = {
    import UpdateVodSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.UpdateVodSourceRequest
      .builder()
      .httpPackageConfigurations(httpPackageConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .sourceLocationName(__string.unwrap(sourceLocationName): java.lang.String)
      .vodSourceName(__string.unwrap(vodSourceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.UpdateVodSourceRequest.ReadOnly =
    zio.aws.mediatailor.model.UpdateVodSourceRequest.wrap(buildAwsValue())
}
object UpdateVodSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.UpdateVodSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.UpdateVodSourceRequest =
      zio.aws.mediatailor.model.UpdateVodSourceRequest(
        httpPackageConfigurations.map { item =>
          item.asEditable
        },
        sourceLocationName,
        vodSourceName
      )
    def httpPackageConfigurations
        : List[zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly]
    def sourceLocationName: __string
    def vodSourceName: __string
    def getHttpPackageConfigurations: ZIO[Any, Nothing, List[
      zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly
    ]] = ZIO.succeed(httpPackageConfigurations)
    def getSourceLocationName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(sourceLocationName)
    def getVodSourceName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(vodSourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.UpdateVodSourceRequest
  ) extends zio.aws.mediatailor.model.UpdateVodSourceRequest.ReadOnly {
    override val httpPackageConfigurations
        : List[zio.aws.mediatailor.model.HttpPackageConfiguration.ReadOnly] =
      impl
        .httpPackageConfigurations()
        .asScala
        .map { item =>
          zio.aws.mediatailor.model.HttpPackageConfiguration.wrap(item)
        }
        .toList
    override val sourceLocationName: __string =
      zio.aws.mediatailor.model.primitives.__string(impl.sourceLocationName())
    override val vodSourceName: __string =
      zio.aws.mediatailor.model.primitives.__string(impl.vodSourceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.UpdateVodSourceRequest
  ): zio.aws.mediatailor.model.UpdateVodSourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
