package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.{__timestampUnix, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class UpdateSourceLocationResponse(
    accessConfiguration: Option[zio.aws.mediatailor.model.AccessConfiguration] =
      None,
    arn: Option[__string] = None,
    creationTime: Option[__timestampUnix] = None,
    defaultSegmentDeliveryConfiguration: Option[
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration
    ] = None,
    httpConfiguration: Option[zio.aws.mediatailor.model.HttpConfiguration] =
      None,
    lastModifiedTime: Option[__timestampUnix] = None,
    sourceLocationName: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.UpdateSourceLocationResponse = {
    import UpdateSourceLocationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.UpdateSourceLocationResponse
      .builder()
      .optionallyWith(accessConfiguration.map(value => value.buildAwsValue()))(
        _.accessConfiguration
      )
      .optionallyWith(
        arn.map(value => __string.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        creationTime.map(value => __timestampUnix.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        defaultSegmentDeliveryConfiguration.map(value => value.buildAwsValue())
      )(_.defaultSegmentDeliveryConfiguration)
      .optionallyWith(httpConfiguration.map(value => value.buildAwsValue()))(
        _.httpConfiguration
      )
      .optionallyWith(
        lastModifiedTime.map(value => __timestampUnix.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        sourceLocationName.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.sourceLocationName)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.UpdateSourceLocationResponse.ReadOnly =
    zio.aws.mediatailor.model.UpdateSourceLocationResponse.wrap(buildAwsValue())
}
object UpdateSourceLocationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.UpdateSourceLocationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.UpdateSourceLocationResponse =
      zio.aws.mediatailor.model.UpdateSourceLocationResponse(
        accessConfiguration.map(value => value.asEditable),
        arn.map(value => value),
        creationTime.map(value => value),
        defaultSegmentDeliveryConfiguration.map(value => value.asEditable),
        httpConfiguration.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        sourceLocationName.map(value => value),
        tags.map(value => value)
      )
    def accessConfiguration
        : Option[zio.aws.mediatailor.model.AccessConfiguration.ReadOnly]
    def arn: Option[__string]
    def creationTime: Option[__timestampUnix]
    def defaultSegmentDeliveryConfiguration: Option[
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly
    ]
    def httpConfiguration
        : Option[zio.aws.mediatailor.model.HttpConfiguration.ReadOnly]
    def lastModifiedTime: Option[__timestampUnix]
    def sourceLocationName: Option[__string]
    def tags: Option[Map[__string, __string]]
    def getAccessConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.AccessConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("accessConfiguration", accessConfiguration)
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDefaultSegmentDeliveryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultSegmentDeliveryConfiguration",
      defaultSegmentDeliveryConfiguration
    )
    def getHttpConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.HttpConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("httpConfiguration", httpConfiguration)
    def getLastModifiedTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getSourceLocationName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceLocationName", sourceLocationName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.UpdateSourceLocationResponse
  ) extends zio.aws.mediatailor.model.UpdateSourceLocationResponse.ReadOnly {
    override val accessConfiguration
        : Option[zio.aws.mediatailor.model.AccessConfiguration.ReadOnly] = scala
      .Option(impl.accessConfiguration())
      .map(value => zio.aws.mediatailor.model.AccessConfiguration.wrap(value))
    override val arn: Option[__string] = scala
      .Option(impl.arn())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val creationTime: Option[__timestampUnix] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.mediatailor.model.primitives.__timestampUnix(value))
    override val defaultSegmentDeliveryConfiguration: Option[
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly
    ] = scala
      .Option(impl.defaultSegmentDeliveryConfiguration())
      .map(value =>
        zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration
          .wrap(value)
      )
    override val httpConfiguration
        : Option[zio.aws.mediatailor.model.HttpConfiguration.ReadOnly] = scala
      .Option(impl.httpConfiguration())
      .map(value => zio.aws.mediatailor.model.HttpConfiguration.wrap(value))
    override val lastModifiedTime: Option[__timestampUnix] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.mediatailor.model.primitives.__timestampUnix(value))
    override val sourceLocationName: Option[__string] = scala
      .Option(impl.sourceLocationName())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mediatailor.model.primitives.__string(
              key
            ) -> zio.aws.mediatailor.model.primitives.__string(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.UpdateSourceLocationResponse
  ): zio.aws.mediatailor.model.UpdateSourceLocationResponse.ReadOnly =
    new Wrapper(impl)
}
