package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateChannelRequest(
    channelName: __string,
    outputs: Iterable[zio.aws.mediatailor.model.RequestOutputItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.UpdateChannelRequest = {
    import UpdateChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.UpdateChannelRequest
      .builder()
      .channelName(__string.unwrap(channelName): java.lang.String)
      .outputs(outputs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.UpdateChannelRequest.ReadOnly =
    zio.aws.mediatailor.model.UpdateChannelRequest.wrap(buildAwsValue())
}
object UpdateChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.UpdateChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.UpdateChannelRequest =
      zio.aws.mediatailor.model.UpdateChannelRequest(
        channelName,
        outputs.map { item =>
          item.asEditable
        }
      )
    def channelName: __string
    def outputs: List[zio.aws.mediatailor.model.RequestOutputItem.ReadOnly]
    def getChannelName: ZIO[Any, Nothing, __string] = ZIO.succeed(channelName)
    def getOutputs: ZIO[Any, Nothing, List[
      zio.aws.mediatailor.model.RequestOutputItem.ReadOnly
    ]] = ZIO.succeed(outputs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.UpdateChannelRequest
  ) extends zio.aws.mediatailor.model.UpdateChannelRequest.ReadOnly {
    override val channelName: __string =
      zio.aws.mediatailor.model.primitives.__string(impl.channelName())
    override val outputs
        : List[zio.aws.mediatailor.model.RequestOutputItem.ReadOnly] = impl
      .outputs()
      .asScala
      .map { item =>
        zio.aws.mediatailor.model.RequestOutputItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.UpdateChannelRequest
  ): zio.aws.mediatailor.model.UpdateChannelRequest.ReadOnly = new Wrapper(impl)
}
