package zio.aws.mediatailor.model
import java.lang.Integer
import zio.aws.mediatailor.model.primitives.__integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SpliceInsertMessage(
    availNum: Option[__integer] = None,
    availsExpected: Option[__integer] = None,
    spliceEventId: Option[__integer] = None,
    uniqueProgramId: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.SpliceInsertMessage = {
    import SpliceInsertMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.SpliceInsertMessage
      .builder()
      .optionallyWith(availNum.map(value => __integer.unwrap(value): Integer))(
        _.availNum
      )
      .optionallyWith(
        availsExpected.map(value => __integer.unwrap(value): Integer)
      )(_.availsExpected)
      .optionallyWith(
        spliceEventId.map(value => __integer.unwrap(value): Integer)
      )(_.spliceEventId)
      .optionallyWith(
        uniqueProgramId.map(value => __integer.unwrap(value): Integer)
      )(_.uniqueProgramId)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.SpliceInsertMessage.ReadOnly =
    zio.aws.mediatailor.model.SpliceInsertMessage.wrap(buildAwsValue())
}
object SpliceInsertMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.SpliceInsertMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.SpliceInsertMessage =
      zio.aws.mediatailor.model.SpliceInsertMessage(
        availNum.map(value => value),
        availsExpected.map(value => value),
        spliceEventId.map(value => value),
        uniqueProgramId.map(value => value)
      )
    def availNum: Option[__integer]
    def availsExpected: Option[__integer]
    def spliceEventId: Option[__integer]
    def uniqueProgramId: Option[__integer]
    def getAvailNum: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("availNum", availNum)
    def getAvailsExpected: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("availsExpected", availsExpected)
    def getSpliceEventId: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("spliceEventId", spliceEventId)
    def getUniqueProgramId: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("uniqueProgramId", uniqueProgramId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.SpliceInsertMessage
  ) extends zio.aws.mediatailor.model.SpliceInsertMessage.ReadOnly {
    override val availNum: Option[__integer] = scala
      .Option(impl.availNum())
      .map(value => zio.aws.mediatailor.model.primitives.__integer(value))
    override val availsExpected: Option[__integer] = scala
      .Option(impl.availsExpected())
      .map(value => zio.aws.mediatailor.model.primitives.__integer(value))
    override val spliceEventId: Option[__integer] = scala
      .Option(impl.spliceEventId())
      .map(value => zio.aws.mediatailor.model.primitives.__integer(value))
    override val uniqueProgramId: Option[__integer] = scala
      .Option(impl.uniqueProgramId())
      .map(value => zio.aws.mediatailor.model.primitives.__integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.SpliceInsertMessage
  ): zio.aws.mediatailor.model.SpliceInsertMessage.ReadOnly = new Wrapper(impl)
}
