package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.{__timestampUnix, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class SourceLocation(
    accessConfiguration: Option[zio.aws.mediatailor.model.AccessConfiguration] =
      None,
    arn: __string,
    creationTime: Option[__timestampUnix] = None,
    defaultSegmentDeliveryConfiguration: Option[
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration
    ] = None,
    httpConfiguration: zio.aws.mediatailor.model.HttpConfiguration,
    lastModifiedTime: Option[__timestampUnix] = None,
    sourceLocationName: __string,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.SourceLocation = {
    import SourceLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.SourceLocation
      .builder()
      .optionallyWith(accessConfiguration.map(value => value.buildAwsValue()))(
        _.accessConfiguration
      )
      .arn(__string.unwrap(arn): java.lang.String)
      .optionallyWith(
        creationTime.map(value => __timestampUnix.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        defaultSegmentDeliveryConfiguration.map(value => value.buildAwsValue())
      )(_.defaultSegmentDeliveryConfiguration)
      .httpConfiguration(httpConfiguration.buildAwsValue())
      .optionallyWith(
        lastModifiedTime.map(value => __timestampUnix.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .sourceLocationName(__string.unwrap(sourceLocationName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.SourceLocation.ReadOnly =
    zio.aws.mediatailor.model.SourceLocation.wrap(buildAwsValue())
}
object SourceLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.SourceLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.SourceLocation =
      zio.aws.mediatailor.model.SourceLocation(
        accessConfiguration.map(value => value.asEditable),
        arn,
        creationTime.map(value => value),
        defaultSegmentDeliveryConfiguration.map(value => value.asEditable),
        httpConfiguration.asEditable,
        lastModifiedTime.map(value => value),
        sourceLocationName,
        tags.map(value => value)
      )
    def accessConfiguration
        : Option[zio.aws.mediatailor.model.AccessConfiguration.ReadOnly]
    def arn: __string
    def creationTime: Option[__timestampUnix]
    def defaultSegmentDeliveryConfiguration: Option[
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly
    ]
    def httpConfiguration: zio.aws.mediatailor.model.HttpConfiguration.ReadOnly
    def lastModifiedTime: Option[__timestampUnix]
    def sourceLocationName: __string
    def tags: Option[Map[__string, __string]]
    def getAccessConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.AccessConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("accessConfiguration", accessConfiguration)
    def getArn: ZIO[Any, Nothing, __string] = ZIO.succeed(arn)
    def getCreationTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDefaultSegmentDeliveryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultSegmentDeliveryConfiguration",
      defaultSegmentDeliveryConfiguration
    )
    def getHttpConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.mediatailor.model.HttpConfiguration.ReadOnly
    ] = ZIO.succeed(httpConfiguration)
    def getLastModifiedTime: ZIO[Any, AwsError, __timestampUnix] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getSourceLocationName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(sourceLocationName)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.SourceLocation
  ) extends zio.aws.mediatailor.model.SourceLocation.ReadOnly {
    override val accessConfiguration
        : Option[zio.aws.mediatailor.model.AccessConfiguration.ReadOnly] = scala
      .Option(impl.accessConfiguration())
      .map(value => zio.aws.mediatailor.model.AccessConfiguration.wrap(value))
    override val arn: __string =
      zio.aws.mediatailor.model.primitives.__string(impl.arn())
    override val creationTime: Option[__timestampUnix] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.mediatailor.model.primitives.__timestampUnix(value))
    override val defaultSegmentDeliveryConfiguration: Option[
      zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration.ReadOnly
    ] = scala
      .Option(impl.defaultSegmentDeliveryConfiguration())
      .map(value =>
        zio.aws.mediatailor.model.DefaultSegmentDeliveryConfiguration
          .wrap(value)
      )
    override val httpConfiguration
        : zio.aws.mediatailor.model.HttpConfiguration.ReadOnly =
      zio.aws.mediatailor.model.HttpConfiguration.wrap(impl.httpConfiguration())
    override val lastModifiedTime: Option[__timestampUnix] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.mediatailor.model.primitives.__timestampUnix(value))
    override val sourceLocationName: __string =
      zio.aws.mediatailor.model.primitives.__string(impl.sourceLocationName())
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mediatailor.model.primitives.__string(
              key
            ) -> zio.aws.mediatailor.model.primitives.__string(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.SourceLocation
  ): zio.aws.mediatailor.model.SourceLocation.ReadOnly = new Wrapper(impl)
}
