package zio.aws.mediatailor.model
import java.lang.Integer
import zio.aws.mediatailor.model.primitives.{__integerMin1, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutPlaybackConfigurationRequest(
    adDecisionServerUrl: Option[__string] = None,
    availSuppression: Option[zio.aws.mediatailor.model.AvailSuppression] = None,
    bumper: Option[zio.aws.mediatailor.model.Bumper] = None,
    cdnConfiguration: Option[zio.aws.mediatailor.model.CdnConfiguration] = None,
    configurationAliases: Option[Map[__string, Map[__string, __string]]] = None,
    dashConfiguration: Option[
      zio.aws.mediatailor.model.DashConfigurationForPut
    ] = None,
    livePreRollConfiguration: Option[
      zio.aws.mediatailor.model.LivePreRollConfiguration
    ] = None,
    manifestProcessingRules: Option[
      zio.aws.mediatailor.model.ManifestProcessingRules
    ] = None,
    name: Option[__string] = None,
    personalizationThresholdSeconds: Option[__integerMin1] = None,
    slateAdUrl: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None,
    transcodeProfileName: Option[__string] = None,
    videoContentSourceUrl: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.PutPlaybackConfigurationRequest = {
    import PutPlaybackConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.PutPlaybackConfigurationRequest
      .builder()
      .optionallyWith(
        adDecisionServerUrl.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.adDecisionServerUrl)
      .optionallyWith(availSuppression.map(value => value.buildAwsValue()))(
        _.availSuppression
      )
      .optionallyWith(bumper.map(value => value.buildAwsValue()))(_.bumper)
      .optionallyWith(cdnConfiguration.map(value => value.buildAwsValue()))(
        _.cdnConfiguration
      )
      .optionallyWith(
        configurationAliases.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value
                .map({ case (key, value) =>
                  (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                    value
                  ): java.lang.String)
                })
                .asJava
            })
            .asJava
        )
      )(_.configurationAliases)
      .optionallyWith(dashConfiguration.map(value => value.buildAwsValue()))(
        _.dashConfiguration
      )
      .optionallyWith(
        livePreRollConfiguration.map(value => value.buildAwsValue())
      )(_.livePreRollConfiguration)
      .optionallyWith(
        manifestProcessingRules.map(value => value.buildAwsValue())
      )(_.manifestProcessingRules)
      .optionallyWith(
        name.map(value => __string.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        personalizationThresholdSeconds.map(value =>
          __integerMin1.unwrap(value): Integer
        )
      )(_.personalizationThresholdSeconds)
      .optionallyWith(
        slateAdUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.slateAdUrl)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        transcodeProfileName.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.transcodeProfileName)
      .optionallyWith(
        videoContentSourceUrl.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.videoContentSourceUrl)
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.PutPlaybackConfigurationRequest.ReadOnly =
    zio.aws.mediatailor.model.PutPlaybackConfigurationRequest
      .wrap(buildAwsValue())
}
object PutPlaybackConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.PutPlaybackConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.PutPlaybackConfigurationRequest =
      zio.aws.mediatailor.model.PutPlaybackConfigurationRequest(
        adDecisionServerUrl.map(value => value),
        availSuppression.map(value => value.asEditable),
        bumper.map(value => value.asEditable),
        cdnConfiguration.map(value => value.asEditable),
        configurationAliases.map(value => value),
        dashConfiguration.map(value => value.asEditable),
        livePreRollConfiguration.map(value => value.asEditable),
        manifestProcessingRules.map(value => value.asEditable),
        name.map(value => value),
        personalizationThresholdSeconds.map(value => value),
        slateAdUrl.map(value => value),
        tags.map(value => value),
        transcodeProfileName.map(value => value),
        videoContentSourceUrl.map(value => value)
      )
    def adDecisionServerUrl: Option[__string]
    def availSuppression
        : Option[zio.aws.mediatailor.model.AvailSuppression.ReadOnly]
    def bumper: Option[zio.aws.mediatailor.model.Bumper.ReadOnly]
    def cdnConfiguration
        : Option[zio.aws.mediatailor.model.CdnConfiguration.ReadOnly]
    def configurationAliases: Option[Map[__string, Map[__string, __string]]]
    def dashConfiguration
        : Option[zio.aws.mediatailor.model.DashConfigurationForPut.ReadOnly]
    def livePreRollConfiguration
        : Option[zio.aws.mediatailor.model.LivePreRollConfiguration.ReadOnly]
    def manifestProcessingRules
        : Option[zio.aws.mediatailor.model.ManifestProcessingRules.ReadOnly]
    def name: Option[__string]
    def personalizationThresholdSeconds: Option[__integerMin1]
    def slateAdUrl: Option[__string]
    def tags: Option[Map[__string, __string]]
    def transcodeProfileName: Option[__string]
    def videoContentSourceUrl: Option[__string]
    def getAdDecisionServerUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("adDecisionServerUrl", adDecisionServerUrl)
    def getAvailSuppression: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.AvailSuppression.ReadOnly
    ] = AwsError.unwrapOptionField("availSuppression", availSuppression)
    def getBumper
        : ZIO[Any, AwsError, zio.aws.mediatailor.model.Bumper.ReadOnly] =
      AwsError.unwrapOptionField("bumper", bumper)
    def getCdnConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.CdnConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("cdnConfiguration", cdnConfiguration)
    def getConfigurationAliases
        : ZIO[Any, AwsError, Map[__string, Map[__string, __string]]] =
      AwsError.unwrapOptionField("configurationAliases", configurationAliases)
    def getDashConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.DashConfigurationForPut.ReadOnly
    ] = AwsError.unwrapOptionField("dashConfiguration", dashConfiguration)
    def getLivePreRollConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.LivePreRollConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "livePreRollConfiguration",
      livePreRollConfiguration
    )
    def getManifestProcessingRules: ZIO[
      Any,
      AwsError,
      zio.aws.mediatailor.model.ManifestProcessingRules.ReadOnly
    ] = AwsError.unwrapOptionField(
      "manifestProcessingRules",
      manifestProcessingRules
    )
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getPersonalizationThresholdSeconds: ZIO[Any, AwsError, __integerMin1] =
      AwsError.unwrapOptionField(
        "personalizationThresholdSeconds",
        personalizationThresholdSeconds
      )
    def getSlateAdUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("slateAdUrl", slateAdUrl)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTranscodeProfileName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("transcodeProfileName", transcodeProfileName)
    def getVideoContentSourceUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("videoContentSourceUrl", videoContentSourceUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.PutPlaybackConfigurationRequest
  ) extends zio.aws.mediatailor.model.PutPlaybackConfigurationRequest.ReadOnly {
    override val adDecisionServerUrl: Option[__string] = scala
      .Option(impl.adDecisionServerUrl())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val availSuppression
        : Option[zio.aws.mediatailor.model.AvailSuppression.ReadOnly] = scala
      .Option(impl.availSuppression())
      .map(value => zio.aws.mediatailor.model.AvailSuppression.wrap(value))
    override val bumper: Option[zio.aws.mediatailor.model.Bumper.ReadOnly] =
      scala
        .Option(impl.bumper())
        .map(value => zio.aws.mediatailor.model.Bumper.wrap(value))
    override val cdnConfiguration
        : Option[zio.aws.mediatailor.model.CdnConfiguration.ReadOnly] = scala
      .Option(impl.cdnConfiguration())
      .map(value => zio.aws.mediatailor.model.CdnConfiguration.wrap(value))
    override val configurationAliases
        : Option[Map[__string, Map[__string, __string]]] = scala
      .Option(impl.configurationAliases())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mediatailor.model.primitives.__string(key) -> value.asScala
              .map({ case (key, value) =>
                zio.aws.mediatailor.model.primitives.__string(
                  key
                ) -> zio.aws.mediatailor.model.primitives.__string(value)
              })
              .toMap
          })
          .toMap
      )
    override val dashConfiguration
        : Option[zio.aws.mediatailor.model.DashConfigurationForPut.ReadOnly] =
      scala
        .Option(impl.dashConfiguration())
        .map(value =>
          zio.aws.mediatailor.model.DashConfigurationForPut.wrap(value)
        )
    override val livePreRollConfiguration
        : Option[zio.aws.mediatailor.model.LivePreRollConfiguration.ReadOnly] =
      scala
        .Option(impl.livePreRollConfiguration())
        .map(value =>
          zio.aws.mediatailor.model.LivePreRollConfiguration.wrap(value)
        )
    override val manifestProcessingRules
        : Option[zio.aws.mediatailor.model.ManifestProcessingRules.ReadOnly] =
      scala
        .Option(impl.manifestProcessingRules())
        .map(value =>
          zio.aws.mediatailor.model.ManifestProcessingRules.wrap(value)
        )
    override val name: Option[__string] = scala
      .Option(impl.name())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val personalizationThresholdSeconds: Option[__integerMin1] = scala
      .Option(impl.personalizationThresholdSeconds())
      .map(value => zio.aws.mediatailor.model.primitives.__integerMin1(value))
    override val slateAdUrl: Option[__string] = scala
      .Option(impl.slateAdUrl())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mediatailor.model.primitives.__string(
              key
            ) -> zio.aws.mediatailor.model.primitives.__string(value)
          })
          .toMap
      )
    override val transcodeProfileName: Option[__string] = scala
      .Option(impl.transcodeProfileName())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val videoContentSourceUrl: Option[__string] = scala
      .Option(impl.videoContentSourceUrl())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.PutPlaybackConfigurationRequest
  ): zio.aws.mediatailor.model.PutPlaybackConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
