package zio.aws.mediatailor.model
import java.lang.Integer
import zio.aws.mediatailor.model.primitives.{__integer, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LivePreRollConfiguration(
    adDecisionServerUrl: Option[__string] = None,
    maxDurationSeconds: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.LivePreRollConfiguration = {
    import LivePreRollConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.LivePreRollConfiguration
      .builder()
      .optionallyWith(
        adDecisionServerUrl.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.adDecisionServerUrl)
      .optionallyWith(
        maxDurationSeconds.map(value => __integer.unwrap(value): Integer)
      )(_.maxDurationSeconds)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.LivePreRollConfiguration.ReadOnly =
    zio.aws.mediatailor.model.LivePreRollConfiguration.wrap(buildAwsValue())
}
object LivePreRollConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.LivePreRollConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.LivePreRollConfiguration =
      zio.aws.mediatailor.model.LivePreRollConfiguration(
        adDecisionServerUrl.map(value => value),
        maxDurationSeconds.map(value => value)
      )
    def adDecisionServerUrl: Option[__string]
    def maxDurationSeconds: Option[__integer]
    def getAdDecisionServerUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("adDecisionServerUrl", adDecisionServerUrl)
    def getMaxDurationSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxDurationSeconds", maxDurationSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.LivePreRollConfiguration
  ) extends zio.aws.mediatailor.model.LivePreRollConfiguration.ReadOnly {
    override val adDecisionServerUrl: Option[__string] = scala
      .Option(impl.adDecisionServerUrl())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val maxDurationSeconds: Option[__integer] = scala
      .Option(impl.maxDurationSeconds())
      .map(value => zio.aws.mediatailor.model.primitives.__integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.LivePreRollConfiguration
  ): zio.aws.mediatailor.model.LivePreRollConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
