package zio.aws.mediatailor.model
import zio.aws.mediatailor.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListPlaybackConfigurationsResponse(
    items: Option[Iterable[zio.aws.mediatailor.model.PlaybackConfiguration]] =
      None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsResponse = {
    import ListPlaybackConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.mediatailor.model.ListPlaybackConfigurationsResponse.ReadOnly =
    zio.aws.mediatailor.model.ListPlaybackConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListPlaybackConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mediatailor.model.ListPlaybackConfigurationsResponse =
      zio.aws.mediatailor.model.ListPlaybackConfigurationsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items
        : Option[List[zio.aws.mediatailor.model.PlaybackConfiguration.ReadOnly]]
    def nextToken: Option[__string]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.mediatailor.model.PlaybackConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsResponse
  ) extends zio.aws.mediatailor.model.ListPlaybackConfigurationsResponse.ReadOnly {
    override val items: Option[
      List[zio.aws.mediatailor.model.PlaybackConfiguration.ReadOnly]
    ] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediatailor.model.PlaybackConfiguration.wrap(item)
        }.toList
      )
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsResponse
  ): zio.aws.mediatailor.model.ListPlaybackConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
