package zio.aws.mediatailor.model
import java.lang.Integer
import zio.aws.mediatailor.model.primitives.{MaxResults, __string}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetChannelScheduleRequest(
    channelName: __string,
    durationMinutes: Option[__string] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest = {
    import GetChannelScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest
      .builder()
      .channelName(__string.unwrap(channelName): java.lang.String)
      .optionallyWith(
        durationMinutes.map(value => __string.unwrap(value): java.lang.String)
      )(_.durationMinutes)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.GetChannelScheduleRequest.ReadOnly =
    zio.aws.mediatailor.model.GetChannelScheduleRequest.wrap(buildAwsValue())
}
object GetChannelScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.GetChannelScheduleRequest =
      zio.aws.mediatailor.model.GetChannelScheduleRequest(
        channelName,
        durationMinutes.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def channelName: __string
    def durationMinutes: Option[__string]
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def getChannelName: ZIO[Any, Nothing, __string] = ZIO.succeed(channelName)
    def getDurationMinutes: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("durationMinutes", durationMinutes)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest
  ) extends zio.aws.mediatailor.model.GetChannelScheduleRequest.ReadOnly {
    override val channelName: __string =
      zio.aws.mediatailor.model.primitives.__string(impl.channelName())
    override val durationMinutes: Option[__string] = scala
      .Option(impl.durationMinutes())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.mediatailor.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.mediatailor.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest
  ): zio.aws.mediatailor.model.GetChannelScheduleRequest.ReadOnly = new Wrapper(
    impl
  )
}
