package zio.aws.mediatailor.model
import java.lang.Integer
import zio.aws.mediatailor.model.primitives.__integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DashPlaylistSettings(
    manifestWindowSeconds: Option[__integer] = None,
    minBufferTimeSeconds: Option[__integer] = None,
    minUpdatePeriodSeconds: Option[__integer] = None,
    suggestedPresentationDelaySeconds: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediatailor.model.DashPlaylistSettings = {
    import DashPlaylistSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediatailor.model.DashPlaylistSettings
      .builder()
      .optionallyWith(
        manifestWindowSeconds.map(value => __integer.unwrap(value): Integer)
      )(_.manifestWindowSeconds)
      .optionallyWith(
        minBufferTimeSeconds.map(value => __integer.unwrap(value): Integer)
      )(_.minBufferTimeSeconds)
      .optionallyWith(
        minUpdatePeriodSeconds.map(value => __integer.unwrap(value): Integer)
      )(_.minUpdatePeriodSeconds)
      .optionallyWith(
        suggestedPresentationDelaySeconds.map(value =>
          __integer.unwrap(value): Integer
        )
      )(_.suggestedPresentationDelaySeconds)
      .build()
  }
  def asReadOnly: zio.aws.mediatailor.model.DashPlaylistSettings.ReadOnly =
    zio.aws.mediatailor.model.DashPlaylistSettings.wrap(buildAwsValue())
}
object DashPlaylistSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediatailor.model.DashPlaylistSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediatailor.model.DashPlaylistSettings =
      zio.aws.mediatailor.model.DashPlaylistSettings(
        manifestWindowSeconds.map(value => value),
        minBufferTimeSeconds.map(value => value),
        minUpdatePeriodSeconds.map(value => value),
        suggestedPresentationDelaySeconds.map(value => value)
      )
    def manifestWindowSeconds: Option[__integer]
    def minBufferTimeSeconds: Option[__integer]
    def minUpdatePeriodSeconds: Option[__integer]
    def suggestedPresentationDelaySeconds: Option[__integer]
    def getManifestWindowSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("manifestWindowSeconds", manifestWindowSeconds)
    def getMinBufferTimeSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("minBufferTimeSeconds", minBufferTimeSeconds)
    def getMinUpdatePeriodSeconds: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("minUpdatePeriodSeconds", minUpdatePeriodSeconds)
    def getSuggestedPresentationDelaySeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField(
        "suggestedPresentationDelaySeconds",
        suggestedPresentationDelaySeconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediatailor.model.DashPlaylistSettings
  ) extends zio.aws.mediatailor.model.DashPlaylistSettings.ReadOnly {
    override val manifestWindowSeconds: Option[__integer] = scala
      .Option(impl.manifestWindowSeconds())
      .map(value => zio.aws.mediatailor.model.primitives.__integer(value))
    override val minBufferTimeSeconds: Option[__integer] = scala
      .Option(impl.minBufferTimeSeconds())
      .map(value => zio.aws.mediatailor.model.primitives.__integer(value))
    override val minUpdatePeriodSeconds: Option[__integer] = scala
      .Option(impl.minUpdatePeriodSeconds())
      .map(value => zio.aws.mediatailor.model.primitives.__integer(value))
    override val suggestedPresentationDelaySeconds: Option[__integer] = scala
      .Option(impl.suggestedPresentationDelaySeconds())
      .map(value => zio.aws.mediatailor.model.primitives.__integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediatailor.model.DashPlaylistSettings
  ): zio.aws.mediatailor.model.DashPlaylistSettings.ReadOnly = new Wrapper(impl)
}
